/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum SASLQualityOfProtection {
    AUTH("auth"),
    AUTH_INT("auth-int"),
    AUTH_CONF("auth-conf");

    @NotNull
    private final String qopString;

    private SASLQualityOfProtection(String qopString) {
        this.qopString = qopString;
    }

    @Nullable
    public static SASLQualityOfProtection forName(@NotNull String name) {
        switch (StaticUtils.toLowerCase(name)) {
            case "auth": {
                return AUTH;
            }
            case "authint": 
            case "auth-int": 
            case "auth_int": {
                return AUTH_INT;
            }
            case "authconf": 
            case "auth-conf": 
            case "auth_conf": {
                return AUTH_CONF;
            }
        }
        return null;
    }

    @NotNull
    public static List<SASLQualityOfProtection> decodeQoPList(@Nullable String s) throws LDAPException {
        ArrayList<SASLQualityOfProtection> qopValues = new ArrayList<SASLQualityOfProtection>(3);
        if (s == null || s.isEmpty()) {
            return qopValues;
        }
        StringTokenizer tokenizer = new StringTokenizer(s, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            SASLQualityOfProtection qop = SASLQualityOfProtection.forName(token);
            if (qop == null) {
                throw new LDAPException(ResultCode.PARAM_ERROR, LDAPMessages.ERR_SASL_QOP_DECODE_LIST_INVALID_ELEMENT.get(token, SASLQualityOfProtection.AUTH.qopString, SASLQualityOfProtection.AUTH_INT.qopString, SASLQualityOfProtection.AUTH_CONF.qopString));
            }
            qopValues.add(qop);
        }
        return qopValues;
    }

    @NotNull
    public String toString() {
        return this.qopString;
    }

    @NotNull
    public static String toString(@NotNull List<SASLQualityOfProtection> qopValues) {
        if (qopValues == null || qopValues.isEmpty()) {
            return SASLQualityOfProtection.AUTH.qopString;
        }
        StringBuilder buffer = new StringBuilder(23);
        Iterator<SASLQualityOfProtection> iterator = qopValues.iterator();
        while (iterator.hasNext()) {
            buffer.append(iterator.next().qopString);
            if (!iterator.hasNext()) continue;
            buffer.append(',');
        }
        return buffer.toString();
    }
}

