/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.spring.autodeployment;

import org.flowable.common.spring.CommonAutoDeploymentProperties;
import org.flowable.eventregistry.api.EventDeploymentBuilder;
import org.flowable.eventregistry.api.EventRepositoryService;
import org.flowable.eventregistry.impl.EventRegistryEngine;
import org.flowable.eventregistry.spring.autodeployment.AbstractEventAutoDeploymentStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class DefaultAutoDeploymentStrategy
extends AbstractEventAutoDeploymentStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAutoDeploymentStrategy.class);
    public static final String DEPLOYMENT_MODE = "default";

    public DefaultAutoDeploymentStrategy() {
    }

    public DefaultAutoDeploymentStrategy(CommonAutoDeploymentProperties deploymentProperties) {
        super(deploymentProperties);
    }

    protected String getDeploymentMode() {
        return DEPLOYMENT_MODE;
    }

    protected void deployResourcesInternal(String deploymentNameHint, Resource[] resources, EventRegistryEngine engine) {
        EventRepositoryService repositoryService = engine.getEventRepositoryService();
        EventDeploymentBuilder deploymentBuilder = repositoryService.createDeployment().enableDuplicateFiltering().name(deploymentNameHint);
        for (Resource resource : resources) {
            this.addResource(resource, deploymentBuilder);
        }
        try {
            deploymentBuilder.deploy();
        }
        catch (RuntimeException e) {
            if (this.isThrowExceptionOnDeploymentFailure()) {
                throw e;
            }
            LOGGER.warn("Exception while autodeploying event definitions. This exception can be ignored if the root cause indicates a unique constraint violation, which is typically caused by two (or more) servers booting up at the exact same time and deploying the same definitions. ", (Throwable)e);
        }
    }
}

