/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AnyTypeTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.DuplicateException;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.provisioning.api.data.AnyTypeDataBinder;
import org.apache.syncope.core.provisioning.api.event.EntityLifecycleEvent;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class AnyTypeLogic
extends AbstractTransactionalLogic<AnyTypeTO> {
    protected final AnyTypeDataBinder binder;
    protected final AnyTypeDAO anyTypeDAO;
    protected final AnyObjectDAO anyObjectDAO;
    protected final ApplicationEventPublisher publisher;

    public AnyTypeLogic(AnyTypeDataBinder binder, AnyTypeDAO anyTypeDAO, AnyObjectDAO anyObjectDAO, ApplicationEventPublisher publisher) {
        this.binder = binder;
        this.anyTypeDAO = anyTypeDAO;
        this.anyObjectDAO = anyObjectDAO;
        this.publisher = publisher;
    }

    @PreAuthorize(value="hasRole('ANYTYPE_READ')")
    @Transactional(readOnly=true)
    public AnyTypeTO read(String key) {
        AnyType anyType = (AnyType)this.anyTypeDAO.findById(key).orElseThrow(() -> new NotFoundException("AnyType " + key));
        return this.binder.getAnyTypeTO(anyType);
    }

    @PreAuthorize(value="hasRole('ANYTYPE_LIST')")
    @Transactional(readOnly=true)
    public List<AnyTypeTO> list() {
        return this.anyTypeDAO.findAll().stream().map(arg_0 -> ((AnyTypeDataBinder)this.binder).getAnyTypeTO(arg_0)).toList();
    }

    @PreAuthorize(value="hasRole('ANYTYPE_CREATE')")
    public AnyTypeTO create(AnyTypeTO anyTypeTO) {
        if (StringUtils.isBlank((CharSequence)anyTypeTO.getKey())) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
            sce.getElements().add(AnyType.class.getSimpleName() + " key");
            throw sce;
        }
        if (this.anyTypeDAO.existsById(anyTypeTO.getKey())) {
            throw new DuplicateException(anyTypeTO.getKey());
        }
        AnyType anyType = (AnyType)this.anyTypeDAO.save((Entity)this.binder.create(anyTypeTO));
        this.publisher.publishEvent((ApplicationEvent)new EntityLifecycleEvent((Object)this, SyncDeltaType.CREATE, (Entity)anyType, AuthContextUtils.getDomain()));
        return this.binder.getAnyTypeTO(anyType);
    }

    @PreAuthorize(value="hasRole('ANYTYPE_UPDATE')")
    public void update(AnyTypeTO anyTypeTO) {
        AnyType anyType = (AnyType)this.anyTypeDAO.findById(anyTypeTO.getKey()).orElseThrow(() -> new NotFoundException("AnyType " + anyTypeTO.getKey()));
        this.binder.update(anyType, anyTypeTO);
        anyType = (AnyType)this.anyTypeDAO.save((Entity)anyType);
        this.publisher.publishEvent((ApplicationEvent)new EntityLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Entity)anyType, AuthContextUtils.getDomain()));
    }

    @PreAuthorize(value="hasRole('ANYTYPE_DELETE')")
    public AnyTypeTO delete(String key) {
        AnyType anyType = (AnyType)this.anyTypeDAO.findById(key).orElseThrow(() -> new NotFoundException("AnyType " + key));
        Long anyObjects = (Long)this.anyObjectDAO.countByType().get(anyType);
        if (anyObjects != null && anyObjects > 0L) {
            LOG.error("{} AnyObject instances found for {}, aborting", (Object)anyObjects, (Object)anyType);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidAnyType);
            sce.getElements().add("AnyObject instances found for " + key);
            throw sce;
        }
        try {
            AnyTypeTO deleted = this.binder.delete(anyType);
            this.publisher.publishEvent((ApplicationEvent)new EntityLifecycleEvent((Object)this, SyncDeltaType.DELETE, (Entity)anyType, AuthContextUtils.getDomain()));
            return deleted;
        }
        catch (IllegalArgumentException | InvalidDataAccessApiUsageException e) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRequest);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
    }

    @Override
    protected AnyTypeTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                Object object = args[i];
                if (object instanceof String) {
                    String string;
                    key = string = (String)object;
                    continue;
                }
                object = args[i];
                if (!(object instanceof AnyTypeTO)) continue;
                AnyTypeTO anyTypeTO = (AnyTypeTO)object;
                key = anyTypeTO.getKey();
            }
        }
        if (StringUtils.isNotBlank(key)) {
            try {
                return this.binder.getAnyTypeTO((AnyType)this.anyTypeDAO.findById(key).orElseThrow());
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

