/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.google.mail.stream;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import org.apache.camel.CamelContext;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.test.junit5.CamelTestSupport;
import org.apache.camel.test.junit5.TestSupport;
import org.junit.jupiter.api.TestInstance;

/**
 * Abstract base class for GoogleMail Integration tests generated by Camel API component maven plugin.
 */
@TestInstance(TestInstance.Lifecycle.PER_CLASS)
public class AbstractGoogleMailStreamTestSupport extends CamelTestSupport {

    // userid of the currently authenticated user
    protected static final String CURRENT_USERID = "me";
    private static final String TEST_OPTIONS_PROPERTIES = "/test-options.properties";

    @Override
    protected CamelContext createCamelContext() throws Exception {

        final CamelContext context = super.createCamelContext();

        // read GoogleMail component configuration from TEST_OPTIONS_PROPERTIES
        final Properties properties
                = TestSupport.loadExternalPropertiesQuietly(AbstractGoogleMailStreamTestSupport.class, TEST_OPTIONS_PROPERTIES);

        Map<String, Object> options = new HashMap<>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            options.put(entry.getKey().toString(), entry.getValue());
        }

        final GoogleMailStreamConfiguration configuration = new GoogleMailStreamConfiguration();
        PropertyBindingSupport.bindProperties(context, configuration, options);

        // add GoogleMailComponent to Camel context
        final GoogleMailStreamComponent component = new GoogleMailStreamComponent(context);
        component.setConfiguration(configuration);
        context.addComponent("google-mail-stream", component);

        return context;
    }

}
