/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.axes;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.jxpath.BasicNodeSet;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.EvalContext;
import org.apache.commons.jxpath.ri.axes.NodeSetContext;
import org.apache.commons.jxpath.ri.model.NodePointer;

public class UnionContext
extends NodeSetContext {
    private final EvalContext[] contexts;
    private boolean prepared;

    public UnionContext(EvalContext parentContext, EvalContext[] contexts) {
        super(parentContext, new BasicNodeSet());
        this.contexts = contexts;
    }

    @Override
    public int getDocumentOrder() {
        return this.contexts.length > 1 ? 1 : super.getDocumentOrder();
    }

    @Override
    public boolean setPosition(int position) {
        if (!this.prepared) {
            this.prepared = true;
            BasicNodeSet nodeSet = (BasicNodeSet)this.getNodeSet();
            ArrayList<NodePointer> pointers = new ArrayList<NodePointer>();
            for (EvalContext ctx : this.contexts) {
                while (ctx.nextSet()) {
                    while (ctx.nextNode()) {
                        NodePointer ptr = ctx.getCurrentNodePointer();
                        if (pointers.contains(ptr)) continue;
                        pointers.add(ptr);
                    }
                }
            }
            this.sortPointers(pointers);
            Iterator it = pointers.iterator();
            while (it.hasNext()) {
                nodeSet.add((Pointer)it.next());
            }
        }
        return super.setPosition(position);
    }
}

