/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.descriptive;

import org.apache.commons.statistics.descriptive.DoubleStatistic;
import org.apache.commons.statistics.descriptive.StatisticAccumulator;
import org.apache.commons.statistics.descriptive.Statistics;

public final class Product
implements DoubleStatistic,
StatisticAccumulator<Product> {
    private double productValue = 1.0;

    private Product() {
    }

    public static Product create() {
        return new Product();
    }

    public static Product of(double ... values) {
        return Statistics.add(new Product(), values);
    }

    public static Product ofRange(double[] values, int from, int to) {
        Statistics.checkFromToIndex(from, to, values.length);
        return Product.createFromRange(values, from, to);
    }

    static Product createFromRange(double[] values, int from, int to) {
        return Statistics.add(new Product(), values, from, to);
    }

    public static Product of(int ... values) {
        return Statistics.add(new Product(), values);
    }

    public static Product ofRange(int[] values, int from, int to) {
        Statistics.checkFromToIndex(from, to, values.length);
        return Product.createFromRange(values, from, to);
    }

    static Product createFromRange(int[] values, int from, int to) {
        return Statistics.add(new Product(), values, from, to);
    }

    public static Product of(long ... values) {
        return Statistics.add(new Product(), values);
    }

    public static Product ofRange(long[] values, int from, int to) {
        Statistics.checkFromToIndex(from, to, values.length);
        return Product.createFromRange(values, from, to);
    }

    static Product createFromRange(long[] values, int from, int to) {
        return Statistics.add(new Product(), values, from, to);
    }

    @Override
    public void accept(double value) {
        this.productValue *= value;
    }

    @Override
    public double getAsDouble() {
        return this.productValue;
    }

    @Override
    public Product combine(Product other) {
        this.productValue *= other.productValue;
        return this;
    }
}

