/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.shared.caching.lower;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.ehcache.Cache;
import org.ehcache.config.ResourceType;
import org.ehcache.core.CacheConfigurationChangeListener;
import org.ehcache.core.EhcachePrefixLoggerFactory;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.spi.store.tiering.CachingTier;
import org.ehcache.core.spi.store.tiering.LowerCachingTier;
import org.ehcache.impl.internal.store.shared.AbstractPartition;
import org.ehcache.impl.internal.store.shared.composites.CompositeValue;
import org.ehcache.impl.store.HashUtils;
import org.ehcache.spi.resilience.StoreAccessException;
import org.slf4j.Logger;

public class LowerCachingTierPartition<K, V>
extends AbstractPartition<LowerCachingTier<CompositeValue<K>, CompositeValue<V>>>
implements LowerCachingTier<K, V> {
    private final Logger logger = EhcachePrefixLoggerFactory.getLogger(LowerCachingTierPartition.class);
    private final Map<Integer, CachingTier.InvalidationListener<?, ?>> invalidationListenerMap;

    public LowerCachingTierPartition(ResourceType<?> type, int id, LowerCachingTier<CompositeValue<K>, CompositeValue<V>> store, Map<Integer, CachingTier.InvalidationListener<?, ?>> invalidationListenerMap) {
        super(type, id, store);
        this.invalidationListenerMap = invalidationListenerMap;
    }

    @Override
    public void clear() throws StoreAccessException {
        Store realStore = (Store)this.shared();
        Store.Iterator iterator = realStore.iterator();
        while (iterator.hasNext()) {
            Cache.Entry next = iterator.next();
            if (((CompositeValue)next.getKey()).getStoreId() != this.id()) continue;
            realStore.remove(next.getKey());
        }
    }

    @Override
    public void setInvalidationListener(CachingTier.InvalidationListener<K, V> invalidationListener) {
        this.invalidationListenerMap.put(this.id(), invalidationListener);
    }

    @Override
    public List<CacheConfigurationChangeListener> getConfigurationChangeListeners() {
        return ((LowerCachingTier)this.shared()).getConfigurationChangeListeners();
    }

    @Override
    public Store.ValueHolder<V> installMapping(K key, Function<K, Store.ValueHolder<V>> source) throws StoreAccessException {
        return this.decode(((LowerCachingTier)this.shared()).installMapping(this.composite(key), k -> this.encode((Store.ValueHolder)source.apply(k.getValue()))));
    }

    @Override
    public Store.ValueHolder<V> get(K key) throws StoreAccessException {
        return this.decode(((LowerCachingTier)this.shared()).get(this.composite(key)));
    }

    @Override
    public Store.ValueHolder<V> getAndRemove(K key) throws StoreAccessException {
        return this.decode(((LowerCachingTier)this.shared()).getAndRemove(this.composite(key)));
    }

    @Override
    public void invalidate(K key) throws StoreAccessException {
        ((LowerCachingTier)this.shared()).invalidate(this.composite(key));
    }

    @Override
    public void invalidateAll() throws StoreAccessException {
        Store realStore = (Store)this.shared();
        boolean invalidate = true;
        Store.Iterator iterator = realStore.iterator();
        while (iterator.hasNext()) {
            try {
                Cache.Entry next = iterator.next();
                if (((CompositeValue)next.getKey()).getStoreId() != this.id()) continue;
                ((LowerCachingTier)this.shared()).invalidate(next.getKey());
            }
            catch (StoreAccessException cae) {
                invalidate = false;
            }
        }
        if (!invalidate) {
            this.logger.error("Could not invalidate one or more cache entries");
        }
    }

    @Override
    public void invalidateAllWithHash(long keyValueHash) throws StoreAccessException {
        ((LowerCachingTier)this.shared()).invalidateAllWithHash(CompositeValue.compositeHash(this.id(), HashUtils.longHashToInt(keyValueHash)));
    }
}

