/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.SecureCookieCommitListener;
import io.undertow.server.handlers.builder.HandlerBuilder;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class SecureCookieHandler
implements HttpHandler {
    public static final HandlerWrapper WRAPPER = new HandlerWrapper(){

        @Override
        public HttpHandler wrap(HttpHandler handler) {
            return new SecureCookieHandler(handler);
        }
    };
    private final HttpHandler next;

    public SecureCookieHandler(HttpHandler next) {
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (exchange.isSecure()) {
            exchange.addResponseCommitListener(SecureCookieCommitListener.INSTANCE);
        }
        this.next.handleRequest(exchange);
    }

    public String toString() {
        return "secure-cookie()";
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "secure-cookie";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.emptyMap();
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.emptySet();
        }

        @Override
        public String defaultParameter() {
            return null;
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            return WRAPPER;
        }
    }
}

