/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jpa.spi.descriptor.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.deltaspike.core.util.AggregatedClassLoader;
import org.apache.deltaspike.jpa.spi.descriptor.xml.Descriptor;
import org.xml.sax.InputSource;

abstract class DescriptorReader {
    private static final Logger LOG = Logger.getLogger(DescriptorReader.class.getName());
    private final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    DescriptorReader() {
    }

    protected List<Descriptor> readAllFromClassPath(String resource) throws IOException {
        LinkedList<Descriptor> result = new LinkedList<Descriptor>();
        Enumeration<URL> urls = this.classLoader().getResources(resource);
        while (urls.hasMoreElements()) {
            URL u = urls.nextElement();
            try {
                result.add(this.readFromUrl(u));
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Could not load " + resource + " from " + u, e);
            }
        }
        return Collections.unmodifiableList(result);
    }

    protected Descriptor readFromClassPath(String resource) throws IOException {
        return this.readFromUrl(this.classLoader().getResource(resource));
    }

    protected Descriptor readFromUrl(URL url) throws IOException {
        try (InputStream stream = url.openStream();){
            DocumentBuilder builder = this.factory.newDocumentBuilder();
            Descriptor descriptor = new Descriptor(builder.parse(new InputSource(stream)), url);
            return descriptor;
        }
    }

    protected Descriptor read(String baseUrl, String resource) throws IOException {
        try {
            URL url = new URL(baseUrl + resource);
            return this.readFromUrl(url);
        }
        catch (Exception e) {
            return this.readFromClassPath(resource);
        }
    }

    protected String extractBaseUrl(URL fileUrl, String resource) {
        String file = fileUrl.toString();
        return file.substring(0, file.length() - resource.length());
    }

    protected ClassLoader classLoader() {
        return AggregatedClassLoader.newInstance();
    }
}

