/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.core.impl.executor;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@ObjectClassDefinition(name="Apache Felix Health Check Executor", description="Runs health checks for a given list of tags in parallel.")
@interface HealthCheckExecutorImplConfiguration {
    public static final long TIMEOUT_DEFAULT_MS = 2000L;
    public static final long LONGRUNNING_FUTURE_THRESHOLD_CRITICAL_DEFAULT_MS = 300000L;
    public static final long RESULT_CACHE_TTL_DEFAULT_MS = 2000L;
    public static final long TEMPORARILY_UNAVAILABLE_GRACE_PERIOD_DEFAULT_MS = 600000L;

    @AttributeDefinition(name="Timeout", description="Timeout in ms until a check is marked as timed out")
    public long timeoutInMs() default 2000L;

    @AttributeDefinition(name="Timeout threshold for CRITICAL", description="Threshold in ms until a check is marked as 'exceedingly' timed out and will marked CRITICAL instead of WARN only")
    public long longRunningFutureThresholdForCriticalMs() default 300000L;

    @AttributeDefinition(name="Results Cache TTL in Ms", description="Result Cache time to live - results will be cached for the given time")
    public long resultCacheTtlInMs() default 2000L;

    @AttributeDefinition(name="TEMPORARILY_UNAVAILABLE Grace Period", description="Grace period in ms until a continuously reported TEMPORARILY_UNAVAILABLE check becomes CRITICAL")
    public long temporarilyAvailableGracePeriodInMs() default 600000L;

    @AttributeDefinition(name="Default Tags", description="Default tags to be executed if no tags are explicitly supplied")
    public String[] defaultTags() default {"default"};

    @AttributeDefinition(name="Auto Logging", description="If enabled, will automatically log entries of ResultLog (or FormattingResultLog resp.) using Log4j. The logging category used is the class instantiating ResultLog prefixed with 'healthchecks.', for instance 'healthchecks.com.mycorp.myplatform.mymodule.ModuleCheck'.")
    public boolean autoLogging() default false;
}

