/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.feature.github.workflows.plain;

import jakarta.inject.Singleton;
import org.grails.forge.application.generator.GeneratorContext;
import org.grails.forge.feature.github.workflows.GitHubWorkflowFeature;
import org.grails.forge.feature.github.workflows.plain.templates.plainGithubWorkflow;
import org.grails.forge.template.RockerTemplate;

@Singleton
public class PlainGithubWorkflowFeature
extends GitHubWorkflowFeature {
    private static final String NAME = "github-workflow-java-ci";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getTitle() {
        return "GitHub Actions CI Workflow";
    }

    @Override
    public String getDescription() {
        return "Add a GitHub Actions workflow that builds and tests the project.";
    }

    @Override
    public void apply(GeneratorContext generatorContext) {
        String workflowFilePath = this.getWorkflowFilePath();
        generatorContext.addTemplate("javaWorkflow", new RockerTemplate(workflowFilePath, plainGithubWorkflow.template(generatorContext.getProject(), generatorContext.getJdkVersion())));
    }

    @Override
    protected String getWorkflowFileName() {
        return "gradle.yml";
    }
}

