/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.event;

import javax.annotation.Nonnull;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleResourceNotFoundException;
import org.apache.guacamole.event.AffectedObject;
import org.apache.guacamole.event.EventLoggingListener;
import org.apache.guacamole.event.Failure;
import org.apache.guacamole.event.RemoteAddress;
import org.apache.guacamole.event.RequestingUser;
import org.apache.guacamole.net.auth.AuthenticationProvider;
import org.apache.guacamole.net.auth.Credentials;
import org.apache.guacamole.net.auth.Identifiable;
import org.apache.guacamole.net.auth.User;
import org.apache.guacamole.net.auth.credentials.GuacamoleInsufficientCredentialsException;
import org.apache.guacamole.net.event.ApplicationShutdownEvent;
import org.apache.guacamole.net.event.ApplicationStartedEvent;
import org.apache.guacamole.net.event.AuthenticationFailureEvent;
import org.apache.guacamole.net.event.AuthenticationRequestReceivedEvent;
import org.apache.guacamole.net.event.AuthenticationSuccessEvent;
import org.apache.guacamole.net.event.DirectoryEvent;
import org.apache.guacamole.net.event.DirectoryFailureEvent;
import org.apache.guacamole.net.event.DirectorySuccessEvent;
import org.apache.guacamole.net.event.FailureEvent;
import org.apache.guacamole.net.event.IdentifiableObjectEvent;
import org.apache.guacamole.net.event.UserEvent;
import org.apache.guacamole.net.event.UserSessionInvalidatedEvent;
import org.apache.guacamole.net.event.listener.Listener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventLoggingListener
implements Listener {
    private final Logger logger = LoggerFactory.getLogger(EventLoggingListener.class);

    private boolean isPasswordAffected(IdentifiableObjectEvent<?> event) {
        Identifiable object = event.getObject();
        if (!(object instanceof User)) {
            return false;
        }
        return ((User)object).getPassword() != null;
    }

    private void logSuccess(DirectorySuccessEvent<?> event) {
        DirectoryEvent.Operation op = event.getOperation();
        switch (1.$SwitchMap$org$apache$guacamole$net$event$DirectoryEvent$Operation[op.ordinal()]) {
            case 1: {
                this.logger.debug("{} successfully accessed/retrieved {}", (Object)new RequestingUser(event), (Object)new AffectedObject(event));
                break;
            }
            case 2: {
                if (this.isPasswordAffected(event)) {
                    this.logger.info("{} successfully created {}, setting their password", (Object)new RequestingUser(event), (Object)new AffectedObject(event));
                    break;
                }
                this.logger.info("{} successfully created {}", (Object)new RequestingUser(event), (Object)new AffectedObject(event));
                break;
            }
            case 3: {
                if (this.isPasswordAffected(event)) {
                    this.logger.info("{} successfully updated {}, changing their password", (Object)new RequestingUser(event), (Object)new AffectedObject(event));
                    break;
                }
                this.logger.info("{} successfully updated {}", (Object)new RequestingUser(event), (Object)new AffectedObject(event));
                break;
            }
            case 4: {
                this.logger.info("{} successfully deleted {}", (Object)new RequestingUser(event), (Object)new AffectedObject(event));
                break;
            }
            default: {
                this.logger.warn("DirectoryEvent operation type has no corresponding log message implemented: {}", (Object)op);
                this.logger.info("{} successfully performed an unknown action on {} {}", (Object)new RequestingUser(event), (Object)new AffectedObject(event));
            }
        }
    }

    private void logFailure(DirectoryFailureEvent<?> event) {
        DirectoryEvent.Operation op = event.getOperation();
        switch (1.$SwitchMap$org$apache$guacamole$net$event$DirectoryEvent$Operation[op.ordinal()]) {
            case 1: {
                if (event.getFailure() instanceof GuacamoleResourceNotFoundException) {
                    this.logger.debug("{} failed to access/retrieve {}: {}", new Object[]{new RequestingUser(event), new AffectedObject(event), new Failure(event)});
                    break;
                }
                this.logger.info("{} failed to access/retrieve {}: {}", new Object[]{new RequestingUser(event), new AffectedObject(event), new Failure(event)});
                break;
            }
            case 2: {
                this.logger.info("{} failed to create {}: {}", new Object[]{new RequestingUser(event), new AffectedObject(event), new Failure(event)});
                break;
            }
            case 3: {
                this.logger.info("{} failed to update {}: {}", new Object[]{new RequestingUser(event), new AffectedObject(event), new Failure(event)});
                break;
            }
            case 4: {
                this.logger.info("{} failed to delete {}: {}", new Object[]{new RequestingUser(event), new AffectedObject(event), new Failure(event)});
                break;
            }
            default: {
                this.logger.warn("DirectoryEvent operation type has no corresponding log message implemented: {}", (Object)op);
                this.logger.info("{} failed to perform an unknown action on {}: {}", new Object[]{new RequestingUser(event), new AffectedObject(event), new Failure(event)});
            }
        }
    }

    private void logSuccess(AuthenticationSuccessEvent event) {
        if (!event.isExistingSession()) {
            this.logger.info("{} successfully authenticated from {}", (Object)new RequestingUser((UserEvent)event), (Object)new RemoteAddress(event.getCredentials()));
        } else {
            this.logger.debug("{} successfully re-authenticated their existing session from {}", (Object)new RequestingUser((UserEvent)event), (Object)new RemoteAddress(event.getCredentials()));
        }
    }

    private void logFailure(AuthenticationFailureEvent event) {
        AuthenticationProvider authProvider = event.getAuthenticationProvider();
        Credentials creds = event.getCredentials();
        String username = creds.getUsername();
        if (creds.isEmpty()) {
            this.logger.debug("Empty authentication attempt (login screen initialization) from {} failed: {}", (Object)new RemoteAddress(creds), (Object)new Failure((FailureEvent)event));
        } else if (username == null || username.isEmpty()) {
            this.logger.debug("Anonymous authentication attempt from {} failed: {}", (Object)new RemoteAddress(creds), (Object)new Failure((FailureEvent)event));
        } else if (event.getFailure() instanceof GuacamoleInsufficientCredentialsException) {
            if (authProvider != null) {
                this.logger.debug("Authentication attempt from {} for user \"{}\" requires additional credentials to continue: {} (requested by \"{}\")", new Object[]{new RemoteAddress(creds), username, new Failure((FailureEvent)event), authProvider.getIdentifier()});
            } else {
                this.logger.debug("Authentication attempt from {} for user \"{}\" requires additional credentials to continue: {}", new Object[]{new RemoteAddress(creds), username, new Failure((FailureEvent)event)});
            }
        } else if (authProvider != null) {
            this.logger.warn("Authentication attempt from {} for user \"{}\" failed: {} (rejected by \"{}\")", new Object[]{new RemoteAddress(creds), username, new Failure((FailureEvent)event), authProvider.getIdentifier()});
        } else {
            this.logger.warn("Authentication attempt from {} for user \"{}\" failed: {}", new Object[]{new RemoteAddress(creds), username, new Failure((FailureEvent)event)});
        }
    }

    public void handleEvent(@Nonnull Object event) throws GuacamoleException {
        if (event instanceof DirectorySuccessEvent) {
            this.logSuccess((DirectorySuccessEvent)event);
        } else if (event instanceof DirectoryFailureEvent) {
            this.logFailure((DirectoryFailureEvent)event);
        } else if (event instanceof AuthenticationSuccessEvent) {
            this.logSuccess((AuthenticationSuccessEvent)event);
        } else if (event instanceof AuthenticationFailureEvent) {
            this.logFailure((AuthenticationFailureEvent)event);
        } else if (event instanceof UserSessionInvalidatedEvent) {
            this.logger.info("{} has logged out, or their session has expired or been terminated.", (Object)new RequestingUser((UserEvent)((UserSessionInvalidatedEvent)event)));
        } else if (event instanceof AuthenticationRequestReceivedEvent) {
            this.logger.trace("Authentication request received from {}", (Object)new RemoteAddress(((AuthenticationRequestReceivedEvent)event).getCredentials()));
        } else if (event instanceof ApplicationStartedEvent) {
            this.logger.info("The Apache Guacamole web application has started.");
        } else if (event instanceof ApplicationShutdownEvent) {
            this.logger.info("The Apache Guacamole web application has shut down.");
        } else {
            this.logger.debug("Ignoring unknown/unimplemented event type: {}", event.getClass());
        }
    }
}

