/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.CallMethodResult;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class CallResponse
extends Structure
implements UaResponseMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=713");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=715");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=714");
    private final ResponseHeader responseHeader;
    private final CallMethodResult[] results;
    private final DiagnosticInfo[] diagnosticInfos;

    public CallResponse(ResponseHeader responseHeader, CallMethodResult[] results, DiagnosticInfo[] diagnosticInfos) {
        this.responseHeader = responseHeader;
        this.results = results;
        this.diagnosticInfos = diagnosticInfos;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    public CallMethodResult[] getResults() {
        return this.results;
    }

    public DiagnosticInfo[] getDiagnosticInfos() {
        return this.diagnosticInfos;
    }

    protected CallResponse(CallResponseBuilder<?, ?> b) {
        super(b);
        this.responseHeader = ((CallResponseBuilder)b).responseHeader;
        this.results = ((CallResponseBuilder)b).results;
        this.diagnosticInfos = ((CallResponseBuilder)b).diagnosticInfos;
    }

    public static CallResponseBuilder<?, ?> builder() {
        return new CallResponseBuilderImpl();
    }

    public CallResponseBuilder<?, ?> toBuilder() {
        return new CallResponseBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CallResponse)) {
            return false;
        }
        CallResponse other = (CallResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResponseHeader this$responseHeader = this.getResponseHeader();
        ResponseHeader other$responseHeader = other.getResponseHeader();
        if (this$responseHeader == null ? other$responseHeader != null : !((Object)this$responseHeader).equals(other$responseHeader)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getResults(), other.getResults())) {
            return false;
        }
        return Arrays.deepEquals(this.getDiagnosticInfos(), other.getDiagnosticInfos());
    }

    protected boolean canEqual(Object other) {
        return other instanceof CallResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResponseHeader $responseHeader = this.getResponseHeader();
        result = result * 59 + ($responseHeader == null ? 43 : ((Object)$responseHeader).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getResults());
        result = result * 59 + Arrays.deepHashCode(this.getDiagnosticInfos());
        return result;
    }

    @Override
    public String toString() {
        return "CallResponse(responseHeader=" + this.getResponseHeader() + ", results=" + Arrays.deepToString(this.getResults()) + ", diagnosticInfos=" + Arrays.deepToString(this.getDiagnosticInfos()) + ")";
    }

    private static final class CallResponseBuilderImpl
    extends CallResponseBuilder<CallResponse, CallResponseBuilderImpl> {
        private CallResponseBuilderImpl() {
        }

        @Override
        protected CallResponseBuilderImpl self() {
            return this;
        }

        @Override
        public CallResponse build() {
            return new CallResponse(this);
        }
    }

    public static abstract class CallResponseBuilder<C extends CallResponse, B extends CallResponseBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private ResponseHeader responseHeader;
        private CallMethodResult[] results;
        private DiagnosticInfo[] diagnosticInfos;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            CallResponseBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(CallResponse instance, CallResponseBuilder<?, ?> b) {
            b.responseHeader(instance.responseHeader);
            b.results(instance.results);
            b.diagnosticInfos(instance.diagnosticInfos);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B responseHeader(ResponseHeader responseHeader) {
            this.responseHeader = responseHeader;
            return (B)this.self();
        }

        public B results(CallMethodResult[] results) {
            this.results = results;
            return (B)this.self();
        }

        public B diagnosticInfos(DiagnosticInfo[] diagnosticInfos) {
            this.diagnosticInfos = diagnosticInfos;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "CallResponse.CallResponseBuilder(super=" + super.toString() + ", responseHeader=" + this.responseHeader + ", results=" + Arrays.deepToString(this.results) + ", diagnosticInfos=" + Arrays.deepToString(this.diagnosticInfos) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<CallResponse> {
        @Override
        public Class<CallResponse> getType() {
            return CallResponse.class;
        }

        @Override
        public CallResponse decode(SerializationContext context, UaDecoder decoder) {
            ResponseHeader responseHeader = (ResponseHeader)decoder.readStruct("ResponseHeader", ResponseHeader.TYPE_ID);
            CallMethodResult[] results = (CallMethodResult[])decoder.readStructArray("Results", CallMethodResult.TYPE_ID);
            DiagnosticInfo[] diagnosticInfos = decoder.readDiagnosticInfoArray("DiagnosticInfos");
            return new CallResponse(responseHeader, results, diagnosticInfos);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, CallResponse value) {
            encoder.writeStruct("ResponseHeader", (Object)value.getResponseHeader(), ResponseHeader.TYPE_ID);
            encoder.writeStructArray("Results", (Object[])value.getResults(), CallMethodResult.TYPE_ID);
            encoder.writeDiagnosticInfoArray("DiagnosticInfos", value.getDiagnosticInfos());
        }
    }
}

