/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools.utils;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.tools.utils.TsFileSequenceScan;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.encoding.decoder.Decoder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.header.ChunkHeader;
import org.apache.tsfile.file.header.PageHeader;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.common.BatchData;
import org.apache.tsfile.read.reader.page.AlignedPageReader;
import org.apache.tsfile.read.reader.page.PageReader;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.TsPrimitiveType;

public class TsFileStatisticScan
extends TsFileSequenceScan {
    private final Map<Pair<IDeviceID, String>, TSDataType> seriesDataTypeMap = new HashMap<Pair<IDeviceID, String>, TSDataType>();
    private final Map<TSDataType, Long> dataTypeSizeMap = new EnumMap<TSDataType, Long>(TSDataType.class);
    private final Map<TSDataType, Long> dataTypePointMap = new EnumMap<TSDataType, Long>(TSDataType.class);
    private final Map<TSDataType, Long> dataTypeChunkMap = new EnumMap<TSDataType, Long>(TSDataType.class);
    private final List<Integer> distinctBinaryValueNumInChunks = new LinkedList<Integer>();
    private int overPrecisedInt64ChunkNum;
    private int justPrecisedInt64ChunkNum;
    private int smallRangeInt64ChunkNum;
    private int largeRangeInt64ChunkNum;
    private boolean currChunkJustPrecised;
    private boolean currChunkLargeRange;
    private Set<Binary> distinctBinarySet = new HashSet<Binary>();
    private PageHeader currTimePageHeader;
    private ByteBuffer currTimePageBuffer;

    public static void main(String[] args) {
        TsFileStatisticScan t = new TsFileStatisticScan();
        t.scanTsFile(new File(args[0]));
    }

    @Override
    protected void onFileEnd() throws IOException {
        super.onFileEnd();
        EnumMap<TSDataType, Integer> seriesTypeCountMap = new EnumMap<TSDataType, Integer>(TSDataType.class);
        for (TSDataType type : this.seriesDataTypeMap.values()) {
            seriesTypeCountMap.compute(type, (t, v) -> v == null ? 1 : v + 1);
        }
        System.out.println("Series data type count: " + seriesTypeCountMap);
        System.out.println("Int64 series statistics: overPrecised " + this.overPrecisedInt64ChunkNum + ", justPrecised " + this.justPrecisedInt64ChunkNum + ", smallRange " + this.smallRangeInt64ChunkNum + ", largeRange " + this.largeRangeInt64ChunkNum);
        System.out.println("data type -> size: " + this.dataTypeSizeMap);
        System.out.println("data type -> point count: " + this.dataTypePointMap);
        System.out.println("data type -> chunk count: " + this.dataTypeChunkMap);
        System.out.println("average distinct binary value num: " + this.distinctBinaryValueNumInChunks.stream().mapToInt(i -> i).average().orElse(0.0));
    }

    @Override
    protected void onChunk(TsFileSequenceScan.PageVisitor pageVisitor) throws IOException {
        this.currChunkJustPrecised = false;
        this.currChunkLargeRange = false;
        super.onChunk(pageVisitor);
        if (!this.isTimeChunk) {
            this.seriesDataTypeMap.computeIfAbsent((Pair<IDeviceID, String>)this.currTimeseriesID, cid -> this.currChunkHeader.getDataType());
            this.dataTypeSizeMap.compute(this.currChunkHeader.getDataType(), (type, size) -> size == null ? (long)(this.currChunkHeader.getSerializedSize() + this.currChunkHeader.getDataSize()) : size + (long)this.currChunkHeader.getSerializedSize() + (long)this.currChunkHeader.getDataSize());
            this.dataTypeChunkMap.compute(this.currChunkHeader.getDataType(), (type, size) -> size == null ? 1L : size + 1L);
        }
        if (this.currChunkHeader.getDataType() == TSDataType.INT64) {
            if (this.currChunkJustPrecised) {
                ++this.justPrecisedInt64ChunkNum;
            } else {
                ++this.overPrecisedInt64ChunkNum;
            }
            if (this.currChunkLargeRange) {
                ++this.largeRangeInt64ChunkNum;
            } else {
                ++this.smallRangeInt64ChunkNum;
            }
        } else if (this.currChunkHeader.getDataType() == TSDataType.TEXT || this.currChunkHeader.getDataType() == TSDataType.STRING) {
            this.distinctBinaryValueNumInChunks.add(this.distinctBinarySet.size());
            this.distinctBinarySet.clear();
        }
    }

    @Override
    protected void onTimePage(PageHeader pageHeader, ByteBuffer pageData, ChunkHeader chunkHeader) throws IOException {
        this.currTimePageHeader = pageHeader;
        this.currTimePageBuffer = pageData;
    }

    @Override
    protected void onValuePage(PageHeader pageHeader, ByteBuffer pageData, ChunkHeader chunkHeader) throws IOException {
        TSDataType dataType = chunkHeader.getDataType();
        if (dataType == TSDataType.INT64) {
            Statistics statistics = pageHeader.getStatistics();
            Long minValue = (Long)statistics.getMinValue();
            Long maxValue = (Long)statistics.getMaxValue();
            if (minValue < Integer.MIN_VALUE || maxValue > Integer.MAX_VALUE) {
                this.currChunkJustPrecised = true;
            }
            if (maxValue - minValue > Integer.MAX_VALUE) {
                this.currChunkLargeRange = true;
            }
        } else if (dataType == TSDataType.TEXT || dataType == TSDataType.STRING) {
            AlignedPageReader pageReader = new AlignedPageReader(this.currTimePageHeader, this.currTimePageBuffer, Decoder.getDecoderByType((TSEncoding)TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getTimeEncoder()), (TSDataType)TSDataType.INT64), Collections.singletonList(pageHeader), Collections.singletonList(pageData), Collections.singletonList(dataType), Collections.singletonList(Decoder.getDecoderByType((TSEncoding)chunkHeader.getEncodingType(), (TSDataType)dataType)), null);
            BatchData batchData = pageReader.getAllSatisfiedPageData();
            while (batchData.hasCurrent()) {
                TsPrimitiveType[] vector = batchData.getVector();
                if (vector[0] != null) {
                    this.distinctBinarySet.add(vector[0].getBinary());
                }
                batchData.next();
            }
        }
        this.dataTypePointMap.compute(this.currChunkHeader.getDataType(), (type, size) -> size == null ? (long)pageHeader.getStatistics().getCount() : size + (long)pageHeader.getStatistics().getCount());
    }

    @Override
    protected void onNonAlignedPage(PageHeader pageHeader, ByteBuffer pageData, ChunkHeader chunkHeader) throws IOException {
        TSDataType dataType = chunkHeader.getDataType();
        if (pageHeader.getStatistics() != null) {
            if (dataType == TSDataType.INT64) {
                Statistics statistics = pageHeader.getStatistics();
                Long minValue = (Long)statistics.getMinValue();
                Long maxValue = (Long)statistics.getMaxValue();
                if (minValue < Integer.MIN_VALUE || maxValue > Integer.MAX_VALUE) {
                    this.currChunkJustPrecised = true;
                }
                if (maxValue - minValue > Integer.MAX_VALUE) {
                    this.currChunkLargeRange = true;
                }
            } else if (dataType == TSDataType.TEXT || dataType == TSDataType.STRING) {
                PageReader pageReader = new PageReader(pageHeader, pageData, chunkHeader.getDataType(), Decoder.getDecoderByType((TSEncoding)chunkHeader.getEncodingType(), (TSDataType)chunkHeader.getDataType()), Decoder.getDecoderByType((TSEncoding)TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getTimeEncoder()), (TSDataType)TSDataType.INT64));
                BatchData allSatisfiedPageData = pageReader.getAllSatisfiedPageData(true);
                while (allSatisfiedPageData.hasCurrent()) {
                    this.distinctBinarySet.add(allSatisfiedPageData.getBinary());
                    allSatisfiedPageData.next();
                }
            }
            this.dataTypePointMap.compute(this.currChunkHeader.getDataType(), (type, size) -> size == null ? (long)pageHeader.getStatistics().getCount() : size + (long)pageHeader.getStatistics().getCount());
        } else {
            PageReader pageReader = new PageReader(pageHeader, pageData, chunkHeader.getDataType(), Decoder.getDecoderByType((TSEncoding)chunkHeader.getEncodingType(), (TSDataType)chunkHeader.getDataType()), Decoder.getDecoderByType((TSEncoding)TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getTimeEncoder()), (TSDataType)TSDataType.INT64));
            BatchData allSatisfiedPageData = pageReader.getAllSatisfiedPageData(true);
            long minLongValue = Long.MAX_VALUE;
            long maxLongValue = Long.MIN_VALUE;
            int cnt = 0;
            while (allSatisfiedPageData.hasCurrent()) {
                if (dataType == TSDataType.INT64) {
                    long val = (Long)allSatisfiedPageData.currentValue();
                    if (val < Integer.MIN_VALUE || val > Integer.MAX_VALUE) {
                        this.currChunkJustPrecised = true;
                    }
                    minLongValue = Math.min(minLongValue, val);
                    maxLongValue = Math.max(maxLongValue, val);
                } else if (dataType == TSDataType.TEXT || dataType == TSDataType.STRING) {
                    this.distinctBinarySet.add(allSatisfiedPageData.getBinary());
                }
                ++cnt;
                allSatisfiedPageData.next();
            }
            int finalCnt = cnt;
            this.dataTypePointMap.compute(this.currChunkHeader.getDataType(), (type, size) -> size == null ? (long)finalCnt : size + (long)finalCnt);
            if (maxLongValue - minLongValue > Integer.MAX_VALUE) {
                this.currChunkLargeRange = true;
            }
        }
    }

    @Override
    protected void onException(Throwable t) {
        t.printStackTrace();
    }
}

