/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.events;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.events.Event;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.acl.ACLDiff;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.model.UpdatedFlags;

public interface MailboxEvents {

    public static class MailboxUnsubscribedEvent
    extends MailboxEvent {
        public MailboxUnsubscribedEvent(MailboxSession.SessionId sessionId, Username username, MailboxPath path, MailboxId mailboxId, Event.EventId eventId) {
            super(sessionId, username, path, mailboxId, eventId);
        }

        public boolean isNoop() {
            return false;
        }

        public final boolean equals(Object o) {
            if (o instanceof MailboxACLUpdated) {
                MailboxACLUpdated that = (MailboxACLUpdated)o;
                return Objects.equals(this.eventId, that.eventId) && Objects.equals(this.sessionId, that.sessionId) && Objects.equals(this.username, that.username) && Objects.equals(this.path, that.path) && Objects.equals(this.mailboxId, that.mailboxId);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.eventId, this.sessionId, this.username, this.path, this.mailboxId);
        }
    }

    public static class MailboxSubscribedEvent
    extends MailboxEvent {
        public MailboxSubscribedEvent(MailboxSession.SessionId sessionId, Username username, MailboxPath path, MailboxId mailboxId, Event.EventId eventId) {
            super(sessionId, username, path, mailboxId, eventId);
        }

        public boolean isNoop() {
            return false;
        }

        public final boolean equals(Object o) {
            if (o instanceof MailboxACLUpdated) {
                MailboxACLUpdated that = (MailboxACLUpdated)o;
                return Objects.equals(this.eventId, that.eventId) && Objects.equals(this.sessionId, that.sessionId) && Objects.equals(this.username, that.username) && Objects.equals(this.path, that.path) && Objects.equals(this.mailboxId, that.mailboxId);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.eventId, this.sessionId, this.username, this.path, this.mailboxId);
        }
    }

    public static class Added
    extends MetaDataHoldingEvent {
        public static boolean IS_DELIVERY = true;
        public static boolean IS_APPENDED = true;
        private final Map<MessageUid, MessageMetaData> added;
        private final boolean isDelivery;
        private final boolean isAppended;
        private final Optional<MailboxId> movedFromMailboxId;

        public Added(MailboxSession.SessionId sessionId, Username username, MailboxPath path, MailboxId mailboxId, SortedMap<MessageUid, MessageMetaData> uids, Event.EventId eventId, boolean isDelivery, boolean isAppended, Optional<MailboxId> movedFromMailboxId) {
            super(sessionId, username, path, mailboxId, eventId);
            this.added = ImmutableMap.copyOf(uids);
            this.isDelivery = isDelivery;
            this.isAppended = isAppended;
            this.movedFromMailboxId = movedFromMailboxId;
        }

        @Override
        public MessageMetaData getMetaData(MessageUid uid) {
            return this.added.get(uid);
        }

        @Override
        public Collection<MessageUid> getUids() {
            return this.added.keySet();
        }

        public Map<MessageUid, MessageMetaData> getAdded() {
            return this.added;
        }

        public boolean isDelivery() {
            return this.isDelivery;
        }

        public boolean isAppended() {
            return this.isAppended;
        }

        public boolean isMoved() {
            return this.movedFromMailboxId.isPresent();
        }

        public Optional<MailboxId> movedFromMailboxId() {
            return this.movedFromMailboxId;
        }

        public boolean isNoop() {
            return this.added.isEmpty();
        }

        public final boolean equals(Object o) {
            if (o instanceof Added) {
                Added that = (Added)o;
                return Objects.equals(this.eventId, that.eventId) && Objects.equals(this.sessionId, that.sessionId) && Objects.equals(this.username, that.username) && Objects.equals(this.path, that.path) && Objects.equals(this.mailboxId, that.mailboxId) && Objects.equals(this.added, that.added) && Objects.equals(this.isAppended, that.isAppended) && Objects.equals(this.movedFromMailboxId, that.movedFromMailboxId) && Objects.equals(this.isDelivery, that.isDelivery);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.eventId, this.sessionId, this.username, this.path, this.mailboxId, this.added, this.isDelivery, this.isAppended, this.movedFromMailboxId);
        }
    }

    public static class FlagsUpdated
    extends MessageEvent {
        private final List<UpdatedFlags> updatedFlags;

        public FlagsUpdated(MailboxSession.SessionId sessionId, Username username, MailboxPath path, MailboxId mailboxId, List<UpdatedFlags> updatedFlags, Event.EventId eventId) {
            super(sessionId, username, path, mailboxId, eventId);
            this.updatedFlags = ImmutableList.copyOf(updatedFlags);
        }

        @Override
        public Collection<MessageUid> getUids() {
            return (Collection)this.updatedFlags.stream().map(UpdatedFlags::getUid).collect(ImmutableList.toImmutableList());
        }

        public Collection<MessageId> getMessageIds() {
            return (Collection)this.updatedFlags.stream().map(UpdatedFlags::getMessageId).flatMap(Optional::stream).collect(ImmutableList.toImmutableList());
        }

        public List<UpdatedFlags> getUpdatedFlags() {
            return this.updatedFlags;
        }

        public boolean isNoop() {
            return this.updatedFlags.isEmpty() || this.updatedFlags.stream().noneMatch(UpdatedFlags::flagsChanged);
        }

        public final boolean equals(Object o) {
            if (o instanceof FlagsUpdated) {
                FlagsUpdated that = (FlagsUpdated)o;
                return Objects.equals(this.eventId, that.eventId) && Objects.equals(this.sessionId, that.sessionId) && Objects.equals(this.username, that.username) && Objects.equals(this.path, that.path) && Objects.equals(this.mailboxId, that.mailboxId) && Objects.equals(this.updatedFlags, that.updatedFlags);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.eventId, this.sessionId, this.username, this.path, this.mailboxId, this.updatedFlags);
        }
    }

    public static class Expunged
    extends MetaDataHoldingEvent {
        private final Map<MessageUid, MessageMetaData> expunged;
        private final Optional<MailboxId> movedToMailboxId;

        public Expunged(MailboxSession.SessionId sessionId, Username username, MailboxPath path, MailboxId mailboxId, Map<MessageUid, MessageMetaData> uids, Event.EventId eventId, Optional<MailboxId> movedToMailboxId) {
            super(sessionId, username, path, mailboxId, eventId);
            this.expunged = ImmutableMap.copyOf(uids);
            this.movedToMailboxId = movedToMailboxId;
        }

        @Override
        public Collection<MessageUid> getUids() {
            return this.expunged.keySet();
        }

        @Override
        public MessageMetaData getMetaData(MessageUid uid) {
            return this.expunged.get(uid);
        }

        public Map<MessageUid, MessageMetaData> getExpunged() {
            return this.expunged;
        }

        public boolean isNoop() {
            return this.expunged.isEmpty();
        }

        public boolean isMoved() {
            return this.movedToMailboxId.isPresent();
        }

        public Optional<MailboxId> movedToMailboxId() {
            return this.movedToMailboxId;
        }

        public final boolean equals(Object o) {
            if (o instanceof Expunged) {
                Expunged that = (Expunged)o;
                return Objects.equals(this.eventId, that.eventId) && Objects.equals(this.sessionId, that.sessionId) && Objects.equals(this.username, that.username) && Objects.equals(this.path, that.path) && Objects.equals(this.mailboxId, that.mailboxId) && Objects.equals(this.movedToMailboxId, that.movedToMailboxId) && Objects.equals(this.expunged, that.expunged);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.eventId, this.sessionId, this.username, this.path, this.mailboxId, this.expunged, this.movedToMailboxId);
        }
    }

    public static abstract class MetaDataHoldingEvent
    extends MessageEvent {
        public MetaDataHoldingEvent(MailboxSession.SessionId sessionId, Username username, MailboxPath path, MailboxId mailboxId, Event.EventId eventId) {
            super(sessionId, username, path, mailboxId, eventId);
        }

        public abstract MessageMetaData getMetaData(MessageUid var1);

        public ImmutableSet<MessageId> getMessageIds() {
            return (ImmutableSet)this.getUids().stream().map(uid -> this.getMetaData((MessageUid)uid).getMessageId()).collect(ImmutableSet.toImmutableSet());
        }
    }

    public static abstract class MessageEvent
    extends MailboxEvent {
        public MessageEvent(MailboxSession.SessionId sessionId, Username username, MailboxPath path, MailboxId mailboxId, Event.EventId eventId) {
            super(sessionId, username, path, mailboxId, eventId);
        }

        public abstract Collection<MessageUid> getUids();
    }

    public static class MailboxACLUpdated
    extends MailboxEvent {
        private final ACLDiff aclDiff;

        public MailboxACLUpdated(MailboxSession.SessionId sessionId, Username username, MailboxPath path, ACLDiff aclDiff, MailboxId mailboxId, Event.EventId eventId) {
            super(sessionId, username, path, mailboxId, eventId);
            this.aclDiff = aclDiff;
        }

        public ACLDiff getAclDiff() {
            return this.aclDiff;
        }

        public boolean isNoop() {
            return this.aclDiff.getNewACL().equals(this.aclDiff.getOldACL());
        }

        public final boolean equals(Object o) {
            if (o instanceof MailboxACLUpdated) {
                MailboxACLUpdated that = (MailboxACLUpdated)o;
                return Objects.equals(this.eventId, that.eventId) && Objects.equals(this.sessionId, that.sessionId) && Objects.equals(this.username, that.username) && Objects.equals(this.path, that.path) && Objects.equals(this.aclDiff, that.aclDiff) && Objects.equals(this.mailboxId, that.mailboxId);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.eventId, this.sessionId, this.username, this.path, this.aclDiff, this.mailboxId);
        }
    }

    public static class MailboxRenamed
    extends MailboxEvent {
        private final MailboxPath newPath;

        public MailboxRenamed(MailboxSession.SessionId sessionId, Username username, MailboxPath path, MailboxId mailboxId, MailboxPath newPath, Event.EventId eventId) {
            super(sessionId, username, path, mailboxId, eventId);
            this.newPath = newPath;
        }

        public boolean isNoop() {
            return this.newPath.equals(this.path);
        }

        public MailboxPath getNewPath() {
            return this.newPath;
        }

        public final boolean equals(Object o) {
            if (o instanceof MailboxRenamed) {
                MailboxRenamed that = (MailboxRenamed)o;
                return Objects.equals(this.eventId, that.eventId) && Objects.equals(this.sessionId, that.sessionId) && Objects.equals(this.username, that.username) && Objects.equals(this.path, that.path) && Objects.equals(this.mailboxId, that.mailboxId) && Objects.equals(this.newPath, that.newPath);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.eventId, this.sessionId, this.username, this.path, this.mailboxId, this.newPath);
        }
    }

    public static class MailboxAdded
    extends MailboxEvent {
        public MailboxAdded(MailboxSession.SessionId sessionId, Username username, MailboxPath path, MailboxId mailboxId, Event.EventId eventId) {
            super(sessionId, username, path, mailboxId, eventId);
        }

        public boolean isNoop() {
            return false;
        }

        public final boolean equals(Object o) {
            if (o instanceof MailboxAdded) {
                MailboxAdded that = (MailboxAdded)o;
                return Objects.equals(this.eventId, that.eventId) && Objects.equals(this.sessionId, that.sessionId) && Objects.equals(this.username, that.username) && Objects.equals(this.path, that.path) && Objects.equals(this.mailboxId, that.mailboxId);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.eventId, this.sessionId, this.username, this.path, this.mailboxId);
        }
    }

    public static class MailboxDeletion
    extends MailboxEvent {
        private final MailboxACL mailboxACL;
        private final QuotaRoot quotaRoot;
        private final QuotaCountUsage deletedMessageCount;
        private final QuotaSizeUsage totalDeletedSize;

        public MailboxDeletion(MailboxSession.SessionId sessionId, Username username, MailboxPath path, MailboxACL mailboxACL, QuotaRoot quotaRoot, QuotaCountUsage deletedMessageCount, QuotaSizeUsage totalDeletedSize, MailboxId mailboxId, Event.EventId eventId) {
            super(sessionId, username, path, mailboxId, eventId);
            this.mailboxACL = mailboxACL;
            this.quotaRoot = quotaRoot;
            this.deletedMessageCount = deletedMessageCount;
            this.totalDeletedSize = totalDeletedSize;
        }

        public boolean isNoop() {
            return false;
        }

        public MailboxACL getMailboxACL() {
            return this.mailboxACL;
        }

        public QuotaRoot getQuotaRoot() {
            return this.quotaRoot;
        }

        public QuotaCountUsage getDeletedMessageCount() {
            return this.deletedMessageCount;
        }

        public QuotaSizeUsage getTotalDeletedSize() {
            return this.totalDeletedSize;
        }

        public final boolean equals(Object o) {
            if (o instanceof MailboxDeletion) {
                MailboxDeletion that = (MailboxDeletion)o;
                return Objects.equals(this.eventId, that.eventId) && Objects.equals(this.sessionId, that.sessionId) && Objects.equals(this.username, that.username) && Objects.equals(this.path, that.path) && Objects.equals(this.mailboxACL, that.mailboxACL) && Objects.equals(this.mailboxId, that.mailboxId) && Objects.equals(this.quotaRoot, that.quotaRoot) && Objects.equals(this.deletedMessageCount, that.deletedMessageCount) && Objects.equals(this.totalDeletedSize, that.totalDeletedSize);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.eventId, this.sessionId, this.username, this.path, this.mailboxACL, this.mailboxId, this.quotaRoot, this.deletedMessageCount, this.totalDeletedSize);
        }
    }

    public static abstract class MailboxEvent
    implements Event {
        protected final MailboxPath path;
        protected final MailboxId mailboxId;
        protected final Username username;
        protected final MailboxSession.SessionId sessionId;
        protected final Event.EventId eventId;

        public MailboxEvent(MailboxSession.SessionId sessionId, Username username, MailboxPath path, MailboxId mailboxId, Event.EventId eventId) {
            this.username = username;
            this.path = path;
            this.mailboxId = mailboxId;
            this.sessionId = sessionId;
            this.eventId = eventId;
        }

        public Username getUsername() {
            return this.username;
        }

        public Event.EventId getEventId() {
            return this.eventId;
        }

        public MailboxSession.SessionId getSessionId() {
            return this.sessionId;
        }

        public MailboxPath getMailboxPath() {
            return this.path;
        }

        public MailboxId getMailboxId() {
            return this.mailboxId;
        }
    }

    public static class QuotaUsageUpdatedEvent
    implements QuotaEvent {
        private final Event.EventId eventId;
        private final Username username;
        private final QuotaRoot quotaRoot;
        private final Quota<QuotaCountLimit, QuotaCountUsage> countQuota;
        private final Quota<QuotaSizeLimit, QuotaSizeUsage> sizeQuota;
        private final Instant instant;

        public QuotaUsageUpdatedEvent(Event.EventId eventId, Username username, QuotaRoot quotaRoot, Quota<QuotaCountLimit, QuotaCountUsage> countQuota, Quota<QuotaSizeLimit, QuotaSizeUsage> sizeQuota, Instant instant) {
            this.eventId = eventId;
            this.username = username;
            this.quotaRoot = quotaRoot;
            this.countQuota = countQuota;
            this.sizeQuota = sizeQuota;
            this.instant = instant;
        }

        public boolean isNoop() {
            return false;
        }

        public Username getUsername() {
            return this.username;
        }

        public Quota<QuotaCountLimit, QuotaCountUsage> getCountQuota() {
            return this.countQuota;
        }

        public Quota<QuotaSizeLimit, QuotaSizeUsage> getSizeQuota() {
            return this.sizeQuota;
        }

        @Override
        public QuotaRoot getQuotaRoot() {
            return this.quotaRoot;
        }

        public Instant getInstant() {
            return this.instant;
        }

        public Event.EventId getEventId() {
            return this.eventId;
        }

        public final boolean equals(Object o) {
            if (o instanceof QuotaUsageUpdatedEvent) {
                QuotaUsageUpdatedEvent that = (QuotaUsageUpdatedEvent)o;
                return Objects.equals(this.eventId, that.eventId) && Objects.equals(this.username, that.username) && Objects.equals(this.quotaRoot, that.quotaRoot) && Objects.equals(this.countQuota, that.countQuota) && Objects.equals(this.sizeQuota, that.sizeQuota) && Objects.equals(this.instant, that.instant);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.eventId, this.username, this.quotaRoot, this.countQuota, this.sizeQuota, this.instant);
        }
    }

    public static interface QuotaEvent
    extends Event {
        public QuotaRoot getQuotaRoot();
    }
}

