/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.delivery;

import com.google.common.base.Preconditions;
import jakarta.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.metrics.api.Metric;
import org.apache.james.transport.mailets.delivery.MailStore;
import org.apache.james.transport.mailets.delivery.MailboxAppender;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.mailet.Mail;
import org.apache.mailet.StorageDirective;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class SimpleMailStore
implements MailStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleMailStore.class);
    private final MailboxAppender mailboxAppender;
    private final UsersRepository usersRepository;
    private final Metric metric;
    private final String folder;

    public static Builder builder() {
        return new Builder();
    }

    private SimpleMailStore(MailboxAppender mailboxAppender, UsersRepository usersRepository, Metric metric, String folder) {
        this.mailboxAppender = mailboxAppender;
        this.usersRepository = usersRepository;
        this.metric = metric;
        this.folder = folder;
    }

    public Mono<ComposedMessageId> storeMail(MailAddress recipient, Mail mail) {
        Username username = this.computeUsername(recipient);
        StorageDirective storageDirective = StorageDirective.fromMail((Username)this.computeUsername(recipient), (Mail)mail).withDefaultFolder(this.folder);
        try {
            return Mono.from(this.mailboxAppender.append(mail.getMessage(), username, storageDirective)).doOnSuccess(ids -> {
                this.metric.increment();
                LOGGER.info("Local delivered mail {} with messageId {} successfully from {} to {} in folder {} with composedMessageId {}", new Object[]{mail.getName(), this.getMessageId(mail), mail.getMaybeSender().asString(), recipient.asPrettyString(), storageDirective.getTargetFolders().get(), ids});
            });
        }
        catch (MessagingException e) {
            throw new RuntimeException("Could not retrieve mail message content", e);
        }
    }

    private Username computeUsername(MailAddress recipient) {
        try {
            return this.usersRepository.getUsername(recipient);
        }
        catch (UsersRepositoryException e) {
            LOGGER.warn("Unable to retrieve username for {}", (Object)recipient.asPrettyString(), (Object)e);
            return Username.of((String)recipient.asString());
        }
    }

    private String getMessageId(Mail mail) {
        try {
            return mail.getMessage().getMessageID();
        }
        catch (MessagingException e) {
            LOGGER.debug("failed to extract messageId from message {}", (Object)mail.getName(), (Object)e);
            return null;
        }
    }

    public static class Builder {
        private UsersRepository usersRepos;
        private MailboxAppender mailboxAppender;
        private String folder;
        private Metric metric;

        public Builder folder(String folder) {
            this.folder = folder;
            return this;
        }

        public Builder usersRepository(UsersRepository usersRepository) {
            this.usersRepos = usersRepository;
            return this;
        }

        public Builder mailboxAppender(MailboxAppender mailboxAppender) {
            this.mailboxAppender = mailboxAppender;
            return this;
        }

        public Builder metric(Metric metric) {
            this.metric = metric;
            return this;
        }

        public SimpleMailStore build() {
            Preconditions.checkNotNull((Object)this.usersRepos);
            Preconditions.checkNotNull((Object)this.folder);
            Preconditions.checkNotNull((Object)this.mailboxAppender);
            Preconditions.checkNotNull((Object)this.metric);
            return new SimpleMailStore(this.mailboxAppender, this.usersRepos, this.metric, this.folder);
        }
    }
}

