/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DecimalCodec
implements TypeCodec<BigDecimal> {
    @Override
    @NonNull
    public GenericType<BigDecimal> getJavaType() {
        return GenericType.BIG_DECIMAL;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return DataTypes.DECIMAL;
    }

    @Override
    public boolean accepts(@NonNull Object value) {
        return value instanceof BigDecimal;
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        return BigDecimal.class.isAssignableFrom(javaClass);
    }

    @Override
    @Nullable
    public ByteBuffer encode(@Nullable BigDecimal value, @NonNull ProtocolVersion protocolVersion) {
        if (value == null) {
            return null;
        }
        BigInteger bi = value.unscaledValue();
        int scale = value.scale();
        byte[] bibytes = bi.toByteArray();
        ByteBuffer bytes = ByteBuffer.allocate(4 + bibytes.length);
        bytes.putInt(scale);
        bytes.put(bibytes);
        bytes.rewind();
        return bytes;
    }

    @Override
    @Nullable
    public BigDecimal decode(@Nullable ByteBuffer bytes, @NonNull ProtocolVersion protocolVersion) {
        if (bytes == null || bytes.remaining() == 0) {
            return null;
        }
        if (bytes.remaining() < 4) {
            throw new IllegalArgumentException("Invalid decimal value, expecting at least 4 bytes but got " + bytes.remaining());
        }
        bytes = bytes.duplicate();
        int scale = bytes.getInt();
        byte[] bibytes = new byte[bytes.remaining()];
        bytes.get(bibytes);
        BigInteger bi = new BigInteger(bibytes);
        return new BigDecimal(bi, scale);
    }

    @Override
    @NonNull
    public String format(@Nullable BigDecimal value) {
        return value == null ? "NULL" : value.toString();
    }

    @Override
    @Nullable
    public BigDecimal parse(@Nullable String value) {
        try {
            return value == null || value.isEmpty() || value.equalsIgnoreCase("NULL") ? null : new BigDecimal(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Cannot parse decimal value from \"%s\"", value));
        }
    }
}

