/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.sparql.util.ClsLoader;

public class MappedLoader {
    static Map<String, String> uriMap = new HashMap<String, String>();

    public static boolean isPossibleDynamicURI(String uri, Class<?> expectedClass) {
        String mappedUri = MappedLoader.mapDynamicURI(uri);
        if (mappedUri == null) {
            return false;
        }
        return MappedLoader.loadClass(uri, expectedClass) != null;
    }

    public static String mapDynamicURI(String uri) {
        Map.Entry<String, String> e2;
        if (((String)uri).startsWith("http://jena.hpl.hp.com/ARQ")) {
            String newURI = ((String)uri).replace("http://jena.hpl.hp.com/", "http://jena.apache.org/");
            Log.warnOnce(MappedLoader.class, (String)("Loading function or property function with old style 'jena.hpl.hp.com' used - preferred style is to use 'jena.apache.org': " + (String)uri + " => " + newURI), (Object)uri);
        }
        if ((e2 = MappedLoader.find((String)uri)) == null) {
            if (((String)uri).startsWith("java:")) {
                return uri;
            }
            return null;
        }
        String k = e2.getKey();
        String v = e2.getValue();
        uri = ((String)uri).substring(k.length());
        uri = v + (String)uri;
        return uri;
    }

    private static Map.Entry<String, String> find(String uri) {
        for (Map.Entry<String, String> e2 : uriMap.entrySet()) {
            String k = e2.getKey();
            if (!uri.startsWith(k)) continue;
            return e2;
        }
        return null;
    }

    public static Class<?> loadClass(String uri, Class<?> expectedClass) {
        String mappedUri = MappedLoader.mapDynamicURI(uri);
        if (mappedUri == null) {
            return null;
        }
        return ClsLoader.loadClass(mappedUri, expectedClass);
    }

    static {
        uriMap.put("http://jena.apache.org/ARQ/function#", "java:org.apache.jena.sparql.function.library.");
        uriMap.put("http://jena.hpl.hp.com/ARQ/function#", "java:org.apache.jena.sparql.function.library.");
        uriMap.put("http://jena.apache.org/ARQ/property#", "java:org.apache.jena.sparql.pfunction.library.");
        uriMap.put("http://jena.hpl.hp.com/ARQ/property#", "java:org.apache.jena.sparql.pfunction.library.");
        uriMap.put("http://jena.apache.org/ARQ/procedure#", "java:org.apache.jena.sparql.procedure.library.");
        uriMap.put("java:com.hp.hpl.jena.query.function.library.", "java:org.apache.jena.sparql.function.library.");
        uriMap.put("java:com.hp.hpl.jena.query.pfunction.library.", "java:org.apache.jena.sparql.pfunction.library.");
        uriMap.put("http://www.dotnetrdf.org/leviathan#", "java:org.apache.jena.sparql.function.library.leviathan.");
    }
}

