/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.processor;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdErrorCode;
import com.apicatalog.jsonld.JsonLdOptions;
import com.apicatalog.jsonld.processor.ProcessingRuntime;
import java.time.Duration;
import java.time.Instant;

class Ticker
extends ProcessingRuntime {
    Instant ticker;
    Duration ttl;

    Ticker(JsonLdOptions options) {
        super(options);
        this.ttl = options.getTimeout();
        this.ticker = Instant.now();
    }

    @Override
    public void tick() throws JsonLdError {
        Instant now2 = Instant.now();
        this.ttl = this.ttl.minus(Duration.between(now2, this.ticker).abs());
        if (this.ttl.isNegative()) {
            throw new JsonLdError(JsonLdErrorCode.PROCESSING_TIMEOUT_EXCEEDED);
        }
        this.ticker = now2;
    }

    @Override
    public void resetTicker() {
        this.ticker = Instant.now();
    }
}

