/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.union;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.GeometryFilter;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.util.Assert;

class InputExtracter
implements GeometryFilter {
    private GeometryFactory geomFactory = null;
    private List<Polygon> polygons = new ArrayList<Polygon>();
    private List<LineString> lines = new ArrayList<LineString>();
    private List<Point> points = new ArrayList<Point>();
    private int dimension = -1;

    public static InputExtracter extract(Collection<Geometry> geoms) {
        InputExtracter extracter = new InputExtracter();
        extracter.add(geoms);
        return extracter;
    }

    public static InputExtracter extract(Geometry geom) {
        InputExtracter extracter = new InputExtracter();
        extracter.add(geom);
        return extracter;
    }

    public boolean isEmpty() {
        return this.polygons.isEmpty() && this.lines.isEmpty() && this.points.isEmpty();
    }

    public int getDimension() {
        return this.dimension;
    }

    public GeometryFactory getFactory() {
        return this.geomFactory;
    }

    public List getExtract(int dim) {
        switch (dim) {
            case 0: {
                return this.points;
            }
            case 1: {
                return this.lines;
            }
            case 2: {
                return this.polygons;
            }
        }
        Assert.shouldNeverReachHere("Invalid dimension: " + dim);
        return null;
    }

    private void add(Collection<Geometry> geoms) {
        for (Geometry geom : geoms) {
            this.add(geom);
        }
    }

    private void add(Geometry geom) {
        if (this.geomFactory == null) {
            this.geomFactory = geom.getFactory();
        }
        geom.apply(this);
    }

    @Override
    public void filter(Geometry geom) {
        this.recordDimension(geom.getDimension());
        if (geom instanceof GeometryCollection) {
            return;
        }
        if (geom.isEmpty()) {
            return;
        }
        if (geom instanceof Polygon) {
            this.polygons.add((Polygon)geom);
            return;
        }
        if (geom instanceof LineString) {
            this.lines.add((LineString)geom);
            return;
        }
        if (geom instanceof Point) {
            this.points.add((Point)geom);
            return;
        }
        Assert.shouldNeverReachHere("Unhandled geometry type: " + geom.getGeometryType());
    }

    private void recordDimension(int dim) {
        if (dim > this.dimension) {
            this.dimension = dim;
        }
    }
}

