/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.triangulate;

import java.util.Collection;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.triangulate.quadedge.QuadEdge;
import org.locationtech.jts.triangulate.quadedge.QuadEdgeSubdivision;
import org.locationtech.jts.triangulate.quadedge.Vertex;

public class IncrementalDelaunayTriangulator {
    private QuadEdgeSubdivision subdiv;
    private boolean isUsingTolerance = false;
    private boolean isForceConvex = true;

    public IncrementalDelaunayTriangulator(QuadEdgeSubdivision subdiv) {
        this.subdiv = subdiv;
        this.isUsingTolerance = subdiv.getTolerance() > 0.0;
    }

    public void forceConvex(boolean isForceConvex) {
        this.isForceConvex = isForceConvex;
    }

    public void insertSites(Collection vertices) {
        for (Vertex v : vertices) {
            this.insertSite(v);
        }
    }

    public QuadEdge insertSite(Vertex v) {
        QuadEdge e2 = this.subdiv.locate(v);
        if (this.subdiv.isVertexOfEdge(e2, v)) {
            return e2;
        }
        if (this.subdiv.isOnEdge(e2, v.getCoordinate())) {
            e2 = e2.oPrev();
            this.subdiv.delete(e2.oNext());
        }
        QuadEdge base = this.subdiv.makeEdge(e2.orig(), v);
        QuadEdge.splice(base, e2);
        QuadEdge startEdge = base;
        while ((e2 = (base = this.subdiv.connect(e2, base.sym())).oPrev()).lNext() != startEdge) {
        }
        while (true) {
            QuadEdge t;
            boolean doFlip;
            boolean bl = doFlip = (t = e2.oPrev()).dest().rightOf(e2) && v.isInCircle(e2.orig(), t.dest(), e2.dest());
            if (this.isForceConvex) {
                if (this.isConcaveBoundary(e2)) {
                    doFlip = true;
                } else if (this.isBetweenFrameAndInserted(e2, v)) {
                    doFlip = false;
                }
            }
            if (doFlip) {
                QuadEdge.swap(e2);
                e2 = e2.oPrev();
                continue;
            }
            if (e2.oNext() == startEdge) {
                return base;
            }
            e2 = e2.oNext().lPrev();
        }
    }

    private boolean isConcaveBoundary(QuadEdge e2) {
        if (this.subdiv.isFrameVertex(e2.dest())) {
            return IncrementalDelaunayTriangulator.isConcaveAtOrigin(e2);
        }
        if (this.subdiv.isFrameVertex(e2.orig())) {
            return IncrementalDelaunayTriangulator.isConcaveAtOrigin(e2.sym());
        }
        return false;
    }

    private static boolean isConcaveAtOrigin(QuadEdge e2) {
        Coordinate pn;
        Coordinate p = e2.orig().getCoordinate();
        Coordinate pp = e2.oPrev().dest().getCoordinate();
        boolean isConcave = 1 == Orientation.index(pp, pn = e2.oNext().dest().getCoordinate(), p);
        return isConcave;
    }

    private boolean isBetweenFrameAndInserted(QuadEdge e2, Vertex vInsert) {
        Vertex v1 = e2.oNext().dest();
        Vertex v2 = e2.oPrev().dest();
        return v1 == vInsert && this.subdiv.isFrameVertex(v2) || v2 == vInsert && this.subdiv.isFrameVertex(v1);
    }
}

