/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.juneau.common.internal.SystemUtils;
import org.apache.juneau.internal.SystemEnv;

public class Cache<K, V> {
    private final int maxSize;
    private final ConcurrentHashMap<K, V> cache;
    private final AtomicInteger cacheHits = new AtomicInteger();

    public static <K, V> Builder<K, V> of(Class<K> key, Class<V> type) {
        return new Builder(type);
    }

    protected Cache(Builder<K, V> builder) {
        this.cache = builder.disabled ? null : new ConcurrentHashMap();
        this.maxSize = builder.maxSize;
        if (builder.logOnExit) {
            SystemUtils.shutdownMessage(() -> builder.type.getSimpleName() + " cache:  hits=" + this.cacheHits.get() + ", misses: " + this.cache.size());
        }
    }

    public V get(K key, Supplier<V> supplier) {
        if (this.cache == null || key == null) {
            return supplier.get();
        }
        V v = this.cache.get(key);
        if (v == null) {
            if (this.cache.size() > this.maxSize) {
                this.cache.clear();
            }
            v = supplier.get();
            this.cache.putIfAbsent(key, v);
        } else {
            this.cacheHits.incrementAndGet();
        }
        return v;
    }

    public static class Builder<K, V> {
        boolean disabled;
        boolean logOnExit;
        int maxSize;
        Class<V> type;

        Builder(Class<V> type) {
            this.type = type;
            this.disabled = SystemEnv.env("juneau.cache.disable", false);
            this.maxSize = SystemEnv.env("juneau.cache.maxSize", 1000);
            this.logOnExit = SystemEnv.env("juneau.cache.logOnExit", false);
        }

        public Builder<K, V> disabled() {
            this.disabled = true;
            return this;
        }

        public Builder<K, V> logOnExit() {
            this.logOnExit = true;
            return this;
        }

        public Builder<K, V> maxSize(int value) {
            this.maxSize = value;
            return this;
        }

        public Cache<K, V> build() {
            return new Cache(this);
        }
    }
}

