/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.xml;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import org.apache.camel.CamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.core.xml.AbstractCamelFactoryBean;
import org.apache.camel.processor.errorhandler.RedeliveryPolicy;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.CamelContextHelper;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class AbstractCamelRedeliveryPolicyFactoryBean
extends AbstractCamelFactoryBean<RedeliveryPolicy> {
    @XmlAttribute
    @Metadata(description="Sets the maximum number of times a message exchange will be redelivered. Setting a negative value will retry forever.")
    private String maximumRedeliveries;
    @XmlAttribute
    @Metadata(defaultValue="1000", description="Sets the maximum redelivery delay. Use -1 if you wish to have no maximum")
    private String redeliveryDelay;
    @XmlAttribute
    @Metadata(defaultValue="false", description="Sets whether asynchronous delayed redelivery is allowed. This is disabled by default. When enabled it allows Camel to schedule a future task for delayed redelivery which prevents current thread from blocking while waiting. Exchange which is transacted will however always use synchronous delayed redelivery because the transaction must execute in the same thread context.")
    private String asyncDelayedRedelivery;
    @XmlAttribute
    @Metadata(defaultValue="2", description="Sets the multiplier used to increase the delay between redeliveries if useExponentialBackOff is enabled")
    private String backOffMultiplier;
    @XmlAttribute
    @Metadata(defaultValue="false", description="Enables/disables exponential backoff using the backOffMultiplier to increase the time between retries")
    private String useExponentialBackOff;
    @XmlAttribute
    @Metadata(defaultValue="0.15", description="Sets the factor used for collision avoidance if enabled via useCollisionAvoidance.")
    private String collisionAvoidanceFactor;
    @XmlAttribute
    @Metadata(defaultValue="false", description="Enables/disables collision avoidance which adds some randomization to the backoff timings to reduce contention probability")
    private String useCollisionAvoidance;
    @XmlAttribute
    @Metadata(defaultValue="60000", description="Sets the maximum redelivery delay. Use -1 if you wish to have no maximum")
    private String maximumRedeliveryDelay;
    @XmlAttribute
    @Metadata(defaultValue="ERROR", description="Sets the logging level to use for log messages when retries have been exhausted.")
    private String retriesExhaustedLogLevel;
    @XmlAttribute
    @Metadata(defaultValue="DEBUG", description="Sets the logging level to use for log messages when retries are attempted.")
    private String retryAttemptedLogLevel;
    @XmlAttribute
    @Metadata(defaultValue="0", description="Sets the interval for log messages when retries are attempted.")
    private String retryAttemptedLogInterval;
    @XmlAttribute
    @Metadata(defaultValue="true", description="Sets whether to log retry attempts")
    private String logRetryAttempted;
    @XmlAttribute
    @Metadata(defaultValue="true", description="Sets whether stack traces should be logged or not")
    private String logStackTrace;
    @XmlAttribute
    @Metadata(defaultValue="false", description="Sets whether stack traces should be logged or not")
    private String logRetryStackTrace;
    @XmlAttribute
    @Metadata(defaultValue="false", description="Sets whether errors should be logged even if its handled")
    private String logHandled;
    @XmlAttribute
    @Metadata(defaultValue="true", description="Sets whether errors should be logged when a new exception occurred during handling a previous exception")
    private String logNewException;
    @XmlAttribute
    @Metadata(defaultValue="false", description="Sets whether errors should be logged even if its continued")
    private String logContinued;
    @XmlAttribute
    @Metadata(defaultValue="true", description="Sets whether exhausted exceptions should be logged or not")
    private String logExhausted;
    @XmlAttribute
    @Metadata(defaultValue="false", description="Sets whether to log exhausted errors including message history")
    private String logExhaustedMessageHistory;
    @XmlAttribute
    @Metadata(defaultValue="false", description="Sets whether exhausted message body/headers should be logged with message history included")
    private String logExhaustedMessageBody;
    @XmlAttribute
    @Metadata(defaultValue="false", description="Disables redelivery by setting maximum redeliveries to 0.")
    private String disableRedelivery;
    @XmlAttribute
    @Metadata(description="Sets an optional delay pattern to use instead of fixed delay.")
    private String delayPattern;
    @XmlAttribute
    @Metadata(defaultValue="true", description="Controls whether to allow redelivery while stopping/shutting down a route that uses error handling.")
    private String allowRedeliveryWhileStopping;
    @XmlAttribute
    @Metadata(description="Sets the reference of the instance of {@link org.apache.camel.spi.ExchangeFormatter} to generate the log message from exchange.")
    private String exchangeFormatterRef;

    @Override
    public RedeliveryPolicy getObject() throws Exception {
        RedeliveryPolicy answer = new RedeliveryPolicy();
        CamelContext context = this.getCamelContext();
        if (this.maximumRedeliveries != null) {
            answer.setMaximumRedeliveries(CamelContextHelper.parseInteger((CamelContext)context, (String)this.maximumRedeliveries).intValue());
        }
        if (this.redeliveryDelay != null) {
            answer.setRedeliveryDelay(CamelContextHelper.parseLong((CamelContext)context, (String)this.redeliveryDelay).longValue());
        }
        if (this.asyncDelayedRedelivery != null && CamelContextHelper.parseBoolean((CamelContext)context, (String)this.asyncDelayedRedelivery).booleanValue()) {
            answer.asyncDelayedRedelivery();
        }
        if (this.retriesExhaustedLogLevel != null) {
            answer.setRetriesExhaustedLogLevel(LoggingLevel.valueOf((String)this.retriesExhaustedLogLevel));
        }
        if (this.retryAttemptedLogLevel != null) {
            answer.setRetryAttemptedLogLevel(LoggingLevel.valueOf((String)this.retryAttemptedLogLevel));
        }
        if (this.retryAttemptedLogInterval != null) {
            answer.setRetryAttemptedLogInterval(CamelContextHelper.parseInteger((CamelContext)context, (String)this.retryAttemptedLogInterval).intValue());
        }
        if (this.backOffMultiplier != null) {
            answer.setBackOffMultiplier(CamelContextHelper.parseDouble((CamelContext)context, (String)this.backOffMultiplier).doubleValue());
        }
        if (this.useExponentialBackOff != null) {
            answer.setUseExponentialBackOff(CamelContextHelper.parseBoolean((CamelContext)context, (String)this.useExponentialBackOff).booleanValue());
        }
        if (this.collisionAvoidanceFactor != null) {
            answer.setCollisionAvoidanceFactor(CamelContextHelper.parseDouble((CamelContext)context, (String)this.collisionAvoidanceFactor).doubleValue());
        }
        if (this.useCollisionAvoidance != null) {
            answer.setUseCollisionAvoidance(CamelContextHelper.parseBoolean((CamelContext)context, (String)this.useCollisionAvoidance).booleanValue());
        }
        if (this.maximumRedeliveryDelay != null) {
            answer.setMaximumRedeliveryDelay(CamelContextHelper.parseLong((CamelContext)context, (String)this.maximumRedeliveryDelay).longValue());
        }
        if (this.logStackTrace != null) {
            answer.setLogStackTrace(CamelContextHelper.parseBoolean((CamelContext)context, (String)this.logStackTrace).booleanValue());
        }
        if (this.logRetryStackTrace != null) {
            answer.setLogRetryStackTrace(CamelContextHelper.parseBoolean((CamelContext)context, (String)this.logRetryStackTrace).booleanValue());
        }
        if (this.logHandled != null) {
            answer.setLogHandled(CamelContextHelper.parseBoolean((CamelContext)context, (String)this.logHandled).booleanValue());
        }
        if (this.logNewException != null) {
            answer.setLogNewException(CamelContextHelper.parseBoolean((CamelContext)context, (String)this.logNewException).booleanValue());
        }
        if (this.logContinued != null) {
            answer.setLogContinued(CamelContextHelper.parseBoolean((CamelContext)context, (String)this.logContinued).booleanValue());
        }
        if (this.logRetryAttempted != null) {
            answer.setLogRetryAttempted(CamelContextHelper.parseBoolean((CamelContext)context, (String)this.logRetryAttempted).booleanValue());
        }
        if (this.logExhausted != null) {
            answer.setLogExhausted(CamelContextHelper.parseBoolean((CamelContext)context, (String)this.logExhausted).booleanValue());
        }
        if (this.logExhaustedMessageHistory != null) {
            answer.setLogExhaustedMessageHistory(CamelContextHelper.parseBoolean((CamelContext)context, (String)this.logExhaustedMessageHistory).booleanValue());
        }
        if (this.logExhaustedMessageBody != null) {
            answer.setLogExhaustedMessageBody(CamelContextHelper.parseBoolean((CamelContext)context, (String)this.logExhaustedMessageBody));
        }
        if (this.disableRedelivery != null && CamelContextHelper.parseBoolean((CamelContext)context, (String)this.disableRedelivery).booleanValue()) {
            answer.setMaximumRedeliveries(0);
        }
        if (this.delayPattern != null) {
            answer.setDelayPattern(CamelContextHelper.parseText((CamelContext)context, (String)this.delayPattern));
        }
        if (this.allowRedeliveryWhileStopping != null) {
            answer.setAllowRedeliveryWhileStopping(CamelContextHelper.parseBoolean((CamelContext)context, (String)this.allowRedeliveryWhileStopping).booleanValue());
        }
        if (this.exchangeFormatterRef != null) {
            answer.setExchangeFormatterRef(this.exchangeFormatterRef);
        }
        return answer;
    }

    @Override
    public Class<RedeliveryPolicy> getObjectType() {
        return RedeliveryPolicy.class;
    }

    public String getMaximumRedeliveries() {
        return this.maximumRedeliveries;
    }

    public void setMaximumRedeliveries(String maximumRedeliveries) {
        this.maximumRedeliveries = maximumRedeliveries;
    }

    public String getRedeliveryDelay() {
        return this.redeliveryDelay;
    }

    public void setRedeliveryDelay(String redeliveryDelay) {
        this.redeliveryDelay = redeliveryDelay;
    }

    public String getAsyncDelayedRedelivery() {
        return this.asyncDelayedRedelivery;
    }

    public void setAsyncDelayedRedelivery(String asyncDelayedRedelivery) {
        this.asyncDelayedRedelivery = asyncDelayedRedelivery;
    }

    public String getBackOffMultiplier() {
        return this.backOffMultiplier;
    }

    public void setBackOffMultiplier(String backOffMultiplier) {
        this.backOffMultiplier = backOffMultiplier;
    }

    public String getUseExponentialBackOff() {
        return this.useExponentialBackOff;
    }

    public void setUseExponentialBackOff(String useExponentialBackOff) {
        this.useExponentialBackOff = useExponentialBackOff;
    }

    public String getCollisionAvoidanceFactor() {
        return this.collisionAvoidanceFactor;
    }

    public void setCollisionAvoidanceFactor(String collisionAvoidanceFactor) {
        this.collisionAvoidanceFactor = collisionAvoidanceFactor;
    }

    public String getUseCollisionAvoidance() {
        return this.useCollisionAvoidance;
    }

    public void setUseCollisionAvoidance(String useCollisionAvoidance) {
        this.useCollisionAvoidance = useCollisionAvoidance;
    }

    public String getMaximumRedeliveryDelay() {
        return this.maximumRedeliveryDelay;
    }

    public void setMaximumRedeliveryDelay(String maximumRedeliveryDelay) {
        this.maximumRedeliveryDelay = maximumRedeliveryDelay;
    }

    public String getRetriesExhaustedLogLevel() {
        return this.retriesExhaustedLogLevel;
    }

    public void setRetriesExhaustedLogLevel(String retriesExhaustedLogLevel) {
        this.retriesExhaustedLogLevel = retriesExhaustedLogLevel;
    }

    public String getRetryAttemptedLogLevel() {
        return this.retryAttemptedLogLevel;
    }

    public void setRetryAttemptedLogLevel(String retryAttemptedLogLevel) {
        this.retryAttemptedLogLevel = retryAttemptedLogLevel;
    }

    public String getRetryAttemptedLogInterval() {
        return this.retryAttemptedLogInterval;
    }

    public void setRetryAttemptedLogInterval(String retryAttemptedLogInterval) {
        this.retryAttemptedLogInterval = retryAttemptedLogInterval;
    }

    public String getLogRetryAttempted() {
        return this.logRetryAttempted;
    }

    public void setLogRetryAttempted(String logRetryAttempted) {
        this.logRetryAttempted = logRetryAttempted;
    }

    public String getLogStackTrace() {
        return this.logStackTrace;
    }

    public void setLogStackTrace(String logStackTrace) {
        this.logStackTrace = logStackTrace;
    }

    public String getLogRetryStackTrace() {
        return this.logRetryStackTrace;
    }

    public void setLogRetryStackTrace(String logRetryStackTrace) {
        this.logRetryStackTrace = logRetryStackTrace;
    }

    public String getLogHandled() {
        return this.logHandled;
    }

    public void setLogHandled(String logHandled) {
        this.logHandled = logHandled;
    }

    public String getLogNewException() {
        return this.logNewException;
    }

    public void setLogNewException(String logNewException) {
        this.logNewException = logNewException;
    }

    public String getLogContinued() {
        return this.logContinued;
    }

    public void setLogContinued(String logContinued) {
        this.logContinued = logContinued;
    }

    public String getLogExhausted() {
        return this.logExhausted;
    }

    public void setLogExhausted(String logExhausted) {
        this.logExhausted = logExhausted;
    }

    public String getLogExhaustedMessageHistory() {
        return this.logExhaustedMessageHistory;
    }

    public void setLogExhaustedMessageHistory(String logExhaustedMessageHistory) {
        this.logExhaustedMessageHistory = logExhaustedMessageHistory;
    }

    public String getLogExhaustedMessageBody() {
        return this.logExhaustedMessageBody;
    }

    public void setLogExhaustedMessageBody(String logExhaustedMessageBody) {
        this.logExhaustedMessageBody = logExhaustedMessageBody;
    }

    public String getDisableRedelivery() {
        return this.disableRedelivery;
    }

    public void setDisableRedelivery(String disableRedelivery) {
        this.disableRedelivery = disableRedelivery;
    }

    public String getDelayPattern() {
        return this.delayPattern;
    }

    public void setDelayPattern(String delayPattern) {
        this.delayPattern = delayPattern;
    }

    public String getAllowRedeliveryWhileStopping() {
        return this.allowRedeliveryWhileStopping;
    }

    public void setAllowRedeliveryWhileStopping(String allowRedeliveryWhileStopping) {
        this.allowRedeliveryWhileStopping = allowRedeliveryWhileStopping;
    }

    public String getExchangeFormatterRef() {
        return this.exchangeFormatterRef;
    }

    public void setExchangeFormatterRef(String exchangeFormatterRef) {
        this.exchangeFormatterRef = exchangeFormatterRef;
    }
}

