/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.helpers.AppenderAttachableImpl;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.varia.InterruptUtil;

public class NewAsyncAppender
extends AppenderSkeleton
implements AppenderAttachable {
    public static final int DEFAULT_QUEUE_SIZE = 256;
    int queueSize = 256;
    public static final int DEFAULT_MAX_FLUSH_TIME = 1000;
    int maxFlushTime = 1000;
    AppenderAttachableImpl appenders = new AppenderAttachableImpl();
    AtomicInteger appenderCount = new AtomicInteger(0);
    BlockingQueue<LoggingEvent> blockingQueue;
    Worker worker = new Worker();
    boolean neverBlock = false;
    static final int UNDEFINED = -1;
    int discardingThreshold = -1;
    boolean includeCallerData = false;

    public void activateOptions() {
        if (this.queueSize < 1) {
            LogLog.error("Invalid queue size [" + this.queueSize + "]");
            return;
        }
        this.blockingQueue = new ArrayBlockingQueue<LoggingEvent>(this.queueSize);
        if (this.discardingThreshold == -1) {
            this.discardingThreshold = this.queueSize / 5;
        }
        LogLog.debug("Setting discardingThreshold to " + this.discardingThreshold);
        this.worker.setDaemon(true);
        this.worker.setName("NewAsyncSingleAppender-Worker-" + this.getName());
        this.worker.start();
    }

    protected void append(LoggingEvent event) {
        if (this.isQueueBelowDiscardingThreshold() && this.isDiscardable(event)) {
            return;
        }
        this.preprocess(event);
        this.put(event);
    }

    public boolean isQueueBelowDiscardingThreshold() {
        return this.blockingQueue.remainingCapacity() < this.discardingThreshold;
    }

    protected boolean isDiscardable(LoggingEvent event) {
        Level level = event.getLevel();
        return level.toInt() <= 20000;
    }

    protected void preprocess(LoggingEvent eventObject) {
        eventObject.getNDC();
        eventObject.getThreadName();
        eventObject.getMDCCopy();
        if (this.includeCallerData) {
            eventObject.getLocationInformation();
        }
        eventObject.getRenderedMessage();
        eventObject.getThrowableStrRep();
    }

    private void put(LoggingEvent eventObject) {
        if (this.neverBlock) {
            this.blockingQueue.offer(eventObject);
        } else {
            this.putUninterruptibly(eventObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putUninterruptibly(LoggingEvent eventObject) {
        boolean interrupted = false;
        try {
            while (true) {
                try {
                    this.blockingQueue.put(eventObject);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.worker.interrupt();
        InterruptUtil interruptUtil = new InterruptUtil();
        try {
            interruptUtil.maskInterruptFlag();
            this.worker.join(this.maxFlushTime);
            if (this.worker.isAlive()) {
                LogLog.warn("Max queue flush timeout (" + this.maxFlushTime + " ms) exceeded. Approximately " + this.blockingQueue.size() + " queued events were possibly discarded.");
            } else {
                LogLog.debug("Queue flush finished successfully within timeout.");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            interruptUtil.maskInterruptFlag();
        }
    }

    boolean isClosed() {
        return this.closed;
    }

    public boolean requiresLayout() {
        return false;
    }

    public void addAppender(Appender newAppender) {
        if (this.appenderCount.compareAndSet(0, 1)) {
            LogLog.debug("Attaching appender named [" + newAppender.getName() + "] to NewAsyncAppender.");
            this.appenders.addAppender(newAppender);
        } else {
            LogLog.warn("One and only one appender may be attached to NewAsyncAppender.");
            LogLog.warn("Ignoring additional appender named [" + newAppender.getName() + "]");
        }
    }

    public Enumeration getAllAppenders() {
        return this.appenders.getAllAppenders();
    }

    public Appender getAppender(String name) {
        return this.appenders.getAppender(name);
    }

    public boolean isAttached(Appender appender) {
        return this.appenders.isAttached(appender);
    }

    public void removeAllAppenders() {
        this.appenders.removeAllAppenders();
    }

    public void removeAppender(Appender appender) {
        this.appenders.removeAppender(appender);
    }

    public void removeAppender(String name) {
        this.appenders.removeAppender(name);
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public int getDiscardingThreshold() {
        return this.discardingThreshold;
    }

    public void setDiscardingThreshold(int discardingThreshold) {
        this.discardingThreshold = discardingThreshold;
    }

    public int getMaxFlushTime() {
        return this.maxFlushTime;
    }

    public void setMaxFlushTime(int maxFlushTime) {
        this.maxFlushTime = maxFlushTime;
    }

    public void setNeverBlock(boolean neverBlock) {
        this.neverBlock = neverBlock;
    }

    public boolean isNeverBlock() {
        return this.neverBlock;
    }

    public boolean isIncludeCallerData() {
        return this.includeCallerData;
    }

    public void setIncludeCallerData(boolean includeCallerData) {
        this.includeCallerData = includeCallerData;
    }

    class Worker
    extends Thread {
        Worker() {
        }

        public void run() {
            NewAsyncAppender parent = NewAsyncAppender.this;
            AppenderAttachableImpl appenders = parent.appenders;
            while (!parent.closed) {
                try {
                    ArrayList<LoggingEvent> elements = new ArrayList<LoggingEvent>();
                    LoggingEvent e0 = parent.blockingQueue.take();
                    elements.add(e0);
                    parent.blockingQueue.drainTo(elements);
                    for (LoggingEvent e : elements) {
                        appenders.appendLoopOnAppenders(e);
                    }
                }
                catch (InterruptedException e1) {
                    // empty catch block
                    break;
                }
            }
            LogLog.debug("Worker thread will flush remaining events before exiting. ");
            for (LoggingEvent e : parent.blockingQueue) {
                appenders.appendLoopOnAppenders(e);
                parent.blockingQueue.remove(e);
            }
            appenders.removeAllAppenders();
        }
    }
}

