/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.yahoo;

import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.profile.OAuth10Profile;
import org.pac4j.oauth.profile.yahoo.YahooAddress;
import org.pac4j.oauth.profile.yahoo.YahooDisclosure;
import org.pac4j.oauth.profile.yahoo.YahooEmail;
import org.pac4j.oauth.profile.yahoo.YahooImage;
import org.pac4j.oauth.profile.yahoo.YahooInterest;

public class YahooProfile
extends OAuth10Profile {
    private static final long serialVersionUID = 791758805376191144L;

    public String getEmail() {
        List<YahooEmail> emails = this.getEmails();
        if (emails != null) {
            for (YahooEmail email : emails) {
                if (email == null || !Boolean.TRUE.equals(email.getPrimary()) && emails.size() != 1) continue;
                return email.getHandle();
            }
        }
        return null;
    }

    public String getFirstName() {
        return (String)this.getAttribute("givenName");
    }

    public String getFamilyName() {
        return (String)this.getAttribute("familyName");
    }

    public String getDisplayName() {
        return this.getFirstName() + " " + this.getFamilyName();
    }

    public String getUsername() {
        return (String)this.getAttribute("nickname");
    }

    public Locale getLocale() {
        return (Locale)this.getAttribute("lang");
    }

    public URI getPictureUrl() {
        YahooImage yahooImage = (YahooImage)this.getAttribute("image");
        if (yahooImage != null) {
            return CommonHelper.asURI((String)yahooImage.getImageUrl());
        }
        return null;
    }

    public URI getProfileUrl() {
        return (URI)this.getAttribute("profileUrl");
    }

    public String getAboutMe() {
        return (String)this.getAttribute("aboutMe");
    }

    public List<YahooAddress> getAddresses() {
        return (List)this.getAttribute("addresses");
    }

    public Integer getBirthYear() {
        return (Integer)this.getAttribute("birthYear");
    }

    public Date getBirthdate() {
        return (Date)this.getAttribute("birthdate");
    }

    public Date getCreated() {
        return (Date)this.getAttribute("created");
    }

    public Integer getDisplayAge() {
        return (Integer)this.getAttribute("displayAge");
    }

    public List<YahooDisclosure> getDisclosures() {
        return (List)this.getAttribute("disclosures");
    }

    public List<YahooEmail> getEmails() {
        return (List)this.getAttribute("emails");
    }

    public YahooImage getImage() {
        return (YahooImage)this.getAttribute("image");
    }

    public List<YahooInterest> getInterests() {
        return (List)this.getAttribute("interests");
    }

    public Boolean getIsConnected() {
        return (Boolean)this.getAttribute("isConnected");
    }

    public Date getMemberSince() {
        return (Date)this.getAttribute("memberSince");
    }

    public String getTimeZone() {
        return (String)this.getAttribute("timeZone");
    }

    public Date getUpdated() {
        return (Date)this.getAttribute("updated");
    }

    public String getUri() {
        return (String)this.getAttribute("uri");
    }

    public String getAgeCategory() {
        return (String)this.getAttribute("ageCategory");
    }
}

