/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.map.AbstractHashedMap;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.collections.map.MultiKeyMap;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.knox.gateway.topology.Application;
import org.apache.knox.gateway.topology.Provider;
import org.apache.knox.gateway.topology.Service;
import org.apache.knox.gateway.topology.Version;

public class Topology {
    private URI uri;
    private String name;
    private String defaultServicePath;
    private long timestamp;
    private boolean isGenerated;
    private long redeployTime = -1L;
    public List<Provider> providerList = new ArrayList<Provider>();
    private Map<String, Map<String, Provider>> providerMap = new HashMap<String, Map<String, Provider>>();
    public List<Service> services = new ArrayList<Service>();
    private MultiKeyMap serviceMap;
    List<Application> applications = new ArrayList<Application>();
    private Map<String, Application> applicationMap = new HashMap<String, Application>();
    private ProviderComparator providerComparator = new ProviderComparator();
    private ServiceComparator serviceComparator = new ServiceComparator();
    private ApplicationComparator appComparator = new ApplicationComparator();

    public Topology() {
        this.serviceMap = MultiKeyMap.decorate((AbstractHashedMap)new HashedMap());
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getDefaultServicePath() {
        return this.defaultServicePath;
    }

    public void setDefaultServicePath(String servicePath) {
        this.defaultServicePath = servicePath;
    }

    public void setGenerated(boolean isGenerated) {
        this.isGenerated = isGenerated;
    }

    public boolean isGenerated() {
        return this.isGenerated;
    }

    public long getRedeployTime() {
        return this.redeployTime;
    }

    public void setRedeployTime(long redeployTime) {
        this.redeployTime = redeployTime;
    }

    public Collection<Service> getServices() {
        return this.services;
    }

    public Service getService(String role, String name, Version version) {
        return (Service)this.serviceMap.get((Object)role, (Object)name, (Object)version);
    }

    public void addService(Service service) {
        this.services.add(service);
        this.serviceMap.put((Object)service.getRole(), (Object)service.getName(), (Object)service.getVersion(), (Object)service);
    }

    public Collection<Application> getApplications() {
        return this.applications;
    }

    private static String fixApplicationUrl(String url) {
        if (url == null) {
            url = "/";
        }
        if (!url.startsWith("/")) {
            url = "/" + url;
        }
        return url;
    }

    public Application getApplication(String url) {
        return this.applicationMap.get(Topology.fixApplicationUrl(url));
    }

    public void addApplication(Application application) {
        this.applications.add(application);
        List<String> urls = application.getUrls();
        if (urls == null || urls.isEmpty()) {
            this.applicationMap.put(Topology.fixApplicationUrl(application.getName()), application);
        } else {
            for (String url : application.getUrls()) {
                this.applicationMap.put(Topology.fixApplicationUrl(url), application);
            }
        }
    }

    public Collection<Provider> getProviders() {
        return this.providerList;
    }

    public Provider getProvider(String role, String name) {
        Provider provider = null;
        Map<String, Provider> nameMap = this.providerMap.get(role);
        if (nameMap != null) {
            provider = name != null ? nameMap.get(name) : nameMap.values().stream().filter(Provider::isEnabled).findFirst().orElse((Provider)nameMap.values().toArray()[0]);
        }
        return provider;
    }

    public void addProvider(Provider provider) {
        this.providerList.add(provider);
        String role = provider.getRole();
        Map nameMap = this.providerMap.computeIfAbsent(role, k -> new HashMap());
        nameMap.put(provider.getName(), provider);
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 31).append((Object)this.name).append(this.providerList.stream().sorted(this.providerComparator).collect(Collectors.toList())).append(this.services.stream().sorted(this.serviceComparator).collect(Collectors.toList())).append(this.applications.stream().sorted(this.appComparator).collect(Collectors.toList())).append(this.getRedeployTime()).build();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Topology)) {
            return false;
        }
        Topology other = (Topology)obj;
        return Objects.equals(this.name, other.name) && this.equalProviders(other) && this.equalServices(other) && this.equalApplications(other) && this.getRedeployTime() == other.getRedeployTime();
    }

    private boolean equalProviders(Topology other) {
        if (this.providerList != null) {
            if (other.providerList == null) {
                return false;
            }
            List mySorted = this.providerList.stream().sorted(this.providerComparator).collect(Collectors.toList());
            List otherSorted = other.providerList.stream().sorted(this.providerComparator).collect(Collectors.toList());
            return mySorted.equals(otherSorted);
        }
        return other.providerList == null;
    }

    private boolean equalServices(Topology other) {
        if (this.services != null) {
            if (other.services == null) {
                return false;
            }
            List mySorted = this.services.stream().sorted(this.serviceComparator).collect(Collectors.toList());
            List otherSorted = other.services.stream().sorted(this.serviceComparator).collect(Collectors.toList());
            return mySorted.equals(otherSorted);
        }
        return other.services == null;
    }

    private boolean equalApplications(Topology other) {
        if (this.applications != null) {
            if (other.applications == null) {
                return false;
            }
            List mySorted = this.applications.stream().sorted(this.appComparator).collect(Collectors.toList());
            List otherSorted = other.applications.stream().sorted(this.appComparator).collect(Collectors.toList());
            return mySorted.equals(otherSorted);
        }
        return other.applications == null;
    }

    private static final class ApplicationComparator
    implements Comparator<Application> {
        private ApplicationComparator() {
        }

        @Override
        public int compare(Application o1, Application o2) {
            String name1 = o1.getName();
            return name1 != null ? name1.compareToIgnoreCase(o2.getName()) : 0;
        }
    }

    private static final class ServiceComparator
    implements Comparator<Service> {
        private ServiceComparator() {
        }

        @Override
        public int compare(Service o1, Service o2) {
            String name1 = o1.getName();
            return name1 != null ? name1.compareToIgnoreCase(o2.getName()) : 0;
        }
    }

    private static final class ProviderComparator
    implements Comparator<Provider> {
        private ProviderComparator() {
        }

        @Override
        public int compare(Provider o1, Provider o2) {
            String name1 = o1.getName();
            return name1 != null ? name1.compareToIgnoreCase(o2.getName()) : 0;
        }
    }
}

