/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.validators;

import org.exolab.castor.xml.TypeValidator;
import org.exolab.castor.xml.ValidationContext;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.validators.PatternValidator;

public class ByteValidator
extends PatternValidator
implements TypeValidator {
    private boolean useMin = false;
    private boolean useMax = false;
    private boolean useFixed = false;
    private byte min = 0;
    private byte max = 0;
    private byte fixed = 0;

    public void clearFixed() {
        this.useFixed = false;
    }

    public void clearMax() {
        this.useMax = false;
    }

    public void clearMin() {
        this.useMin = false;
    }

    public Byte getFixed() {
        if (this.useFixed) {
            return new Byte(this.fixed);
        }
        return null;
    }

    public Byte getMaxInclusive() {
        if (this.useMax) {
            return new Byte(this.max);
        }
        return null;
    }

    public Byte getMinInclusive() {
        if (this.useMin) {
            return new Byte(this.min);
        }
        return null;
    }

    public boolean hasFixed() {
        return this.useFixed;
    }

    public void setFixed(byte fixedValue) {
        this.useFixed = true;
        this.fixed = fixedValue;
    }

    public void setMinExclusive(byte minValue) {
        this.useMin = true;
        this.min = (byte)(minValue + 1);
    }

    public void setMinInclusive(byte minValue) {
        this.useMin = true;
        this.min = minValue;
    }

    public void setMaxExclusive(byte maxValue) {
        this.useMax = true;
        this.max = (byte)(maxValue - 1);
    }

    public void setMaxInclusive(byte maxValue) {
        this.useMax = true;
        this.max = maxValue;
    }

    public void validate(byte b, ValidationContext context) throws ValidationException {
        if (this.useFixed) {
            if (b != this.fixed) {
                String err = b + " is not equal to the fixed value of " + this.fixed;
                throw new ValidationException(err);
            }
            return;
        }
        if (this.useMin && b < this.min) {
            String err = b + " is less than the minimum allowable ";
            err = err + "value of " + this.min;
            throw new ValidationException(err);
        }
        if (this.useMax && b > this.max) {
            String err = b + " is greater than the maximum allowable ";
            err = err + "value of " + this.max;
            throw new ValidationException(err);
        }
        if (this.hasPattern()) {
            super.validate(Byte.toString(b), context);
        }
    }

    public void validate(Object object) throws ValidationException {
        this.validate(object, (ValidationContext)null);
    }

    public void validate(Object object, ValidationContext context) throws ValidationException {
        if (object == null) {
            String err = "ByteValidator cannot validate a null object.";
            throw new ValidationException(err);
        }
        byte value = 0;
        try {
            value = (Byte)object;
        }
        catch (Exception ex) {
            String err = "Expecting a Byte, received instead: ";
            err = err + object.getClass().getName();
            throw new ValidationException(err);
        }
        this.validate(value, context);
    }
}

