/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.cli.CoreExtensions;
import org.apache.maven.api.cli.InvokerRequest;
import org.apache.maven.api.cli.Options;
import org.apache.maven.api.cli.ParserRequest;
import org.apache.maven.api.cli.cisupport.CIInfo;

public class BaseInvokerRequest
implements InvokerRequest {
    private final ParserRequest parserRequest;
    private final boolean parsingFailed;
    private final Path cwd;
    private final Path installationDirectory;
    private final Path userHomeDirectory;
    private final Map<String, String> userProperties;
    private final Map<String, String> systemProperties;
    private final Path topDirectory;
    private final Path rootDirectory;
    private final List<CoreExtensions> coreExtensions;
    private final CIInfo ciInfo;
    private final Options options;

    public BaseInvokerRequest(@Nonnull ParserRequest parserRequest, boolean parsingFailed, @Nonnull Path cwd, @Nonnull Path installationDirectory, @Nonnull Path userHomeDirectory, @Nonnull Map<String, String> userProperties, @Nonnull Map<String, String> systemProperties, @Nonnull Path topDirectory, @Nullable Path rootDirectory, @Nullable List<CoreExtensions> coreExtensions, @Nullable CIInfo ciInfo, @Nullable Options options) {
        this.parserRequest = Objects.requireNonNull(parserRequest);
        this.parsingFailed = parsingFailed;
        this.cwd = Objects.requireNonNull(cwd);
        this.installationDirectory = Objects.requireNonNull(installationDirectory);
        this.userHomeDirectory = Objects.requireNonNull(userHomeDirectory);
        this.userProperties = Objects.requireNonNull(userProperties);
        this.systemProperties = Objects.requireNonNull(systemProperties);
        this.topDirectory = Objects.requireNonNull(topDirectory);
        this.rootDirectory = rootDirectory;
        this.coreExtensions = coreExtensions;
        this.ciInfo = ciInfo;
        this.options = options;
    }

    public ParserRequest parserRequest() {
        return this.parserRequest;
    }

    public boolean parsingFailed() {
        return this.parsingFailed;
    }

    public Path cwd() {
        return this.cwd;
    }

    public Path installationDirectory() {
        return this.installationDirectory;
    }

    public Path userHomeDirectory() {
        return this.userHomeDirectory;
    }

    public Map<String, String> userProperties() {
        return this.userProperties;
    }

    public Map<String, String> systemProperties() {
        return this.systemProperties;
    }

    public Path topDirectory() {
        return this.topDirectory;
    }

    public Optional<Path> rootDirectory() {
        return Optional.ofNullable(this.rootDirectory);
    }

    public Optional<List<CoreExtensions>> coreExtensions() {
        return Optional.ofNullable(this.coreExtensions);
    }

    public Optional<CIInfo> ciInfo() {
        return Optional.ofNullable(this.ciInfo);
    }

    public Optional<Options> options() {
        return Optional.ofNullable(this.options);
    }
}

