/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.method.configuration;

import io.micrometer.observation.ObservationRegistry;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.security.authorization.ObservationReactiveAuthorizationManager;
import org.springframework.security.authorization.ReactiveAuthorizationManager;
import org.springframework.security.authorization.method.MethodInvocationResult;
import org.springframework.security.config.ObjectPostProcessor;
import org.springframework.security.config.observation.SecurityObservationSettings;

@Configuration(proxyBeanMethods=false)
@Role(value=2)
class ReactiveMethodObservationConfiguration {
    private static final SecurityObservationSettings all = SecurityObservationSettings.withDefaults().shouldObserveRequests(true).shouldObserveAuthentications(true).shouldObserveAuthorizations(true).build();

    ReactiveMethodObservationConfiguration() {
    }

    @Bean
    @Role(value=2)
    static ObjectPostProcessor<ReactiveAuthorizationManager<MethodInvocation>> methodAuthorizationManagerPostProcessor(final ObjectProvider<ObservationRegistry> registry, final ObjectProvider<SecurityObservationSettings> predicate) {
        return new ObjectPostProcessor<ReactiveAuthorizationManager<MethodInvocation>>(){

            @Override
            public ReactiveAuthorizationManager postProcess(ReactiveAuthorizationManager object) {
                ObservationRegistry r = (ObservationRegistry)registry.getIfUnique(() -> ObservationRegistry.NOOP);
                boolean active = !r.isNoop() && ((SecurityObservationSettings)predicate.getIfUnique(() -> all)).shouldObserveAuthorizations();
                return active ? new ObservationReactiveAuthorizationManager(r, object) : object;
            }
        };
    }

    @Bean
    @Role(value=2)
    static ObjectPostProcessor<ReactiveAuthorizationManager<MethodInvocationResult>> methodResultAuthorizationManagerPostProcessor(final ObjectProvider<ObservationRegistry> registry, final ObjectProvider<SecurityObservationSettings> predicate) {
        return new ObjectPostProcessor<ReactiveAuthorizationManager<MethodInvocationResult>>(){

            @Override
            public ReactiveAuthorizationManager postProcess(ReactiveAuthorizationManager object) {
                ObservationRegistry r = (ObservationRegistry)registry.getIfUnique(() -> ObservationRegistry.NOOP);
                boolean active = !r.isNoop() && ((SecurityObservationSettings)predicate.getIfUnique(() -> all)).shouldObserveAuthorizations();
                return active ? new ObservationReactiveAuthorizationManager(r, object) : object;
            }
        };
    }
}

