/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.crypto;

import java.beans.PropertyEditorSupport;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.security.converter.RsaKeyConverters;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RsaKeyConversionServicePostProcessor
implements BeanFactoryPostProcessor {
    private static final String CONVERSION_SERVICE_BEAN_NAME = "conversionService";
    private ResourceKeyConverterAdapter<RSAPublicKey> x509 = new ResourceKeyConverterAdapter(RsaKeyConverters.x509());
    private ResourceKeyConverterAdapter<RSAPrivateKey> pkcs8 = new ResourceKeyConverterAdapter(RsaKeyConverters.pkcs8());

    public void setResourceLoader(ResourceLoader resourceLoader) {
        Assert.notNull((Object)resourceLoader, (String)"resourceLoader cannot be null");
        this.x509.setResourceLoader(resourceLoader);
        this.pkcs8.setResourceLoader(resourceLoader);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (this.hasUserDefinedConversionService(beanFactory)) {
            return;
        }
        ConversionService service = beanFactory.getConversionService();
        if (service instanceof ConverterRegistry) {
            ConverterRegistry registry2 = (ConverterRegistry)service;
            registry2.addConverter(String.class, RSAPrivateKey.class, this.pkcs8);
            registry2.addConverter(String.class, RSAPublicKey.class, this.x509);
        } else {
            beanFactory.addPropertyEditorRegistrar(registry -> {
                registry.registerCustomEditor(RSAPublicKey.class, new ConverterPropertyEditorAdapter(this.x509));
                registry.registerCustomEditor(RSAPrivateKey.class, new ConverterPropertyEditorAdapter(this.pkcs8));
            });
        }
    }

    private boolean hasUserDefinedConversionService(ConfigurableListableBeanFactory beanFactory) {
        return beanFactory.containsBean(CONVERSION_SERVICE_BEAN_NAME) && beanFactory.isTypeMatch(CONVERSION_SERVICE_BEAN_NAME, ConversionService.class);
    }

    static class ResourceKeyConverterAdapter<T extends Key>
    implements Converter<String, T> {
        private ResourceLoader resourceLoader = new DefaultResourceLoader();
        private final Converter<String, T> delegate;

        ResourceKeyConverterAdapter(Converter<InputStream, T> delegate) {
            this.delegate = this.pemInputStreamConverter().andThen(this.autoclose(delegate));
        }

        public T convert(String source) {
            return (T)((Key)this.delegate.convert((Object)source));
        }

        void setResourceLoader(ResourceLoader resourceLoader) {
            Assert.notNull((Object)resourceLoader, (String)"resourceLoader cannot be null");
            this.resourceLoader = resourceLoader;
        }

        private Converter<String, InputStream> pemInputStreamConverter() {
            return source -> source.startsWith("-----") ? this.toInputStream((String)source) : this.toInputStream(this.resourceLoader.getResource(source));
        }

        private InputStream toInputStream(String raw) {
            return new ByteArrayInputStream(raw.getBytes(StandardCharsets.UTF_8));
        }

        private InputStream toInputStream(Resource resource) {
            try {
                return resource.getInputStream();
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }

        private <T> Converter<InputStream, T> autoclose(Converter<InputStream, T> inputStreamKeyConverter) {
            return inputStream -> {
                Object object;
                block8: {
                    InputStream is = inputStream;
                    try {
                        object = inputStreamKeyConverter.convert((Object)is);
                        if (is == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new UncheckedIOException(ex);
                        }
                    }
                    is.close();
                }
                return object;
            };
        }
    }

    private static class ConverterPropertyEditorAdapter<T>
    extends PropertyEditorSupport {
        private final Converter<String, T> converter;

        ConverterPropertyEditorAdapter(Converter<String, T> converter) {
            this.converter = converter;
        }

        @Override
        public String getAsText() {
            return null;
        }

        @Override
        public void setAsText(String text) throws IllegalArgumentException {
            if (StringUtils.hasText((String)text)) {
                this.setValue(this.converter.convert((Object)text));
            } else {
                this.setValue(null);
            }
        }
    }
}

