/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.registry.extension;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.ParseException;
import org.apache.nifi.registry.client.ExtensionRepoClient;
import org.apache.nifi.registry.client.NiFiRegistryClient;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.registry.AbstractNiFiRegistryCommand;
import org.apache.nifi.toolkit.cli.impl.result.StringResult;

public class GetBundleChecksum
extends AbstractNiFiRegistryCommand<StringResult> {
    public GetBundleChecksum() {
        super("get-bundle-checksum", StringResult.class);
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.BUCKET_NAME.createOption());
        this.addOption(CommandOption.EXT_BUNDLE_GROUP.createOption());
        this.addOption(CommandOption.EXT_BUNDLE_ARTIFACT.createOption());
        this.addOption(CommandOption.EXT_BUNDLE_VERSION.createOption());
    }

    @Override
    public String getDescription() {
        return "Retrieves the SHA-256 checksum for the given bundle.";
    }

    @Override
    public StringResult doExecute(NiFiRegistryClient client, Properties properties) throws IOException, NiFiRegistryException, ParseException {
        String bucketName = this.getRequiredArg(properties, CommandOption.BUCKET_NAME);
        String groupId = this.getRequiredArg(properties, CommandOption.EXT_BUNDLE_GROUP);
        String artifactId = this.getRequiredArg(properties, CommandOption.EXT_BUNDLE_ARTIFACT);
        String version = this.getRequiredArg(properties, CommandOption.EXT_BUNDLE_VERSION);
        ExtensionRepoClient repoClient = client.getExtensionRepoClient();
        String checksum = repoClient.getVersionSha256(bucketName, groupId, artifactId, version);
        return new StringResult(checksum, this.isInteractive());
    }
}

