/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.core;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.Transient;

@Transient
final class SimpleAuthentication
implements Authentication {
    private static final long serialVersionUID = 3194696462184782814L;
    private final @Nullable Object principal;
    private final @Nullable Object credentials;
    private final Collection<GrantedAuthority> authorities;
    private final @Nullable Object details;
    private final boolean authenticated;

    private SimpleAuthentication(Builder builder) {
        this.principal = builder.principal;
        this.credentials = builder.credentials;
        this.authorities = builder.authorities;
        this.details = builder.details;
        this.authenticated = builder.authenticated;
    }

    @Override
    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    @Override
    public @Nullable Object getCredentials() {
        return this.credentials;
    }

    @Override
    public @Nullable Object getDetails() {
        return this.details;
    }

    @Override
    public @Nullable Object getPrincipal() {
        return this.principal;
    }

    @Override
    public boolean isAuthenticated() {
        return this.authenticated;
    }

    @Override
    public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
        throw new IllegalArgumentException("Instead of calling this setter, please call toBuilder to create a new instance");
    }

    @Override
    public String getName() {
        return this.principal == null ? "" : this.principal.toString();
    }

    static final class Builder
    implements Authentication.Builder<Builder> {
        private final Log logger = LogFactory.getLog(this.getClass());
        private final Collection<GrantedAuthority> authorities = new LinkedHashSet<GrantedAuthority>();
        private @Nullable Object principal;
        private @Nullable Object credentials;
        private @Nullable Object details;
        private boolean authenticated;

        Builder(Authentication authentication) {
            this.logger.debug((Object)("Creating a builder which will result in exchanging an authentication of type " + String.valueOf(authentication.getClass()) + " for " + SimpleAuthentication.class.getSimpleName() + "; consider implementing " + authentication.getClass().getSimpleName() + "#toBuilder"));
            this.authorities.addAll(authentication.getAuthorities());
            this.principal = authentication.getPrincipal();
            this.credentials = authentication.getCredentials();
            this.details = authentication.getDetails();
            this.authenticated = authentication.isAuthenticated();
        }

        @Override
        public Builder authorities(Consumer<Collection<GrantedAuthority>> authorities) {
            authorities.accept(this.authorities);
            return this;
        }

        @Override
        public Builder details(@Nullable Object details) {
            this.details = details;
            return this;
        }

        @Override
        public Builder principal(@Nullable Object principal) {
            this.principal = principal;
            return this;
        }

        @Override
        public Builder credentials(@Nullable Object credentials) {
            this.credentials = credentials;
            return this;
        }

        @Override
        public Builder authenticated(boolean authenticated) {
            this.authenticated = authenticated;
            return this;
        }

        @Override
        public Authentication build() {
            return new SimpleAuthentication(this);
        }
    }
}

