/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import org.archive.io.MiserOutputStream;
import org.archive.io.WriterPoolSettings;
import org.archive.util.ArchiveUtils;
import org.archive.util.FileUtils;
import org.archive.util.PropertyUtils;

public abstract class WriterPoolMember {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    public static final String UTF8 = StandardCharsets.UTF_8.name();
    public static final String DEFAULT_TEMPLATE = "${prefix}-${timestamp17}-${serialno}-${heritrix.pid}~${heritrix.hostname}~${heritrix.port}";
    public static final String DEFAULT_PREFIX = "WEB";
    protected File f = null;
    protected OutputStream out = null;
    protected MiserOutputStream countOut = null;
    protected WriterPoolSettings settings;
    private final String extension;
    protected String currentTimestamp = "UNSET!!!";
    protected String currentBasename;
    private final AtomicInteger serialNo;
    protected static int roundRobinIndex = 0;
    protected static DecimalFormatSymbols serialNoFormatterSymbols = new DecimalFormatSymbols(Locale.ROOT);
    protected static NumberFormat serialNoFormatter = new DecimalFormat("00000", serialNoFormatterSymbols);
    protected final byte[] scratchbuffer = new byte[4096];

    protected WriterPoolMember(AtomicInteger serialNo, OutputStream out, File file, WriterPoolSettings settings) throws IOException {
        this(serialNo, settings, null);
        this.countOut = out instanceof MiserOutputStream ? (MiserOutputStream)out : new MiserOutputStream(out, settings.getFrequentFlushes());
        this.out = this.countOut;
        this.f = file;
    }

    public WriterPoolMember(AtomicInteger serialNo, WriterPoolSettings settings, String extension) {
        this.settings = settings;
        this.extension = extension;
        this.serialNo = serialNo;
    }

    public void checkSize() throws IOException {
        if (this.out == null || this.isOversize()) {
            this.createFile();
        }
    }

    public boolean isOversize() {
        return this.settings.getMaxFileSizeBytes() != -1L && this.getPosition() > this.settings.getMaxFileSizeBytes();
    }

    protected String createFile() throws IOException {
        this.generateNewBasename();
        String name = this.currentBasename + '.' + this.extension + (this.settings.getCompress() ? ".gz" : "") + ".open";
        File dir = this.getNextDirectory(this.settings.calcOutputDirs());
        return this.createFile(new File(dir, name));
    }

    protected String createFile(File file) throws IOException {
        this.close();
        this.f = file;
        FileOutputStream fos = new FileOutputStream(this.f);
        this.countOut = new MiserOutputStream(new BufferedOutputStream(fos), this.settings.getFrequentFlushes());
        this.out = this.countOut;
        this.logger.fine("Opened " + this.f.getAbsolutePath());
        return this.f.getName();
    }

    protected File getNextDirectory(List<File> dirs) throws IOException {
        if (roundRobinIndex >= dirs.size()) {
            roundRobinIndex = 0;
        }
        File d = null;
        try {
            d = this.checkWriteable(dirs.get(roundRobinIndex));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        if (d == null && dirs.size() > 1) {
            Iterator<File> i = dirs.iterator();
            while (d == null && i.hasNext()) {
                d = this.checkWriteable(i.next());
            }
        } else {
            ++roundRobinIndex;
        }
        if (d == null) {
            throw new IOException("Directories unusable.");
        }
        return d;
    }

    protected File checkWriteable(File d) {
        if (d == null) {
            return d;
        }
        try {
            FileUtils.ensureWriteableDirectory(d);
        }
        catch (IOException e) {
            this.logger.warning("Directory " + d.getPath() + " is not writeable or cannot be created: " + e.getMessage());
            d = null;
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateNewBasename() {
        Properties localProps = new Properties();
        localProps.setProperty("prefix", this.settings.getPrefix());
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            String paddedSerialNumber = serialNoFormatter.format(this.serialNo.getAndIncrement());
            String timestamp17 = ArchiveUtils.getUnique17DigitDate();
            String timestamp14 = ArchiveUtils.getUnique14DigitDate();
            this.currentTimestamp = timestamp17;
            localProps.setProperty("serialno", paddedSerialNumber);
            localProps.setProperty("timestamp17", timestamp17);
            localProps.setProperty("timestamp14", timestamp14);
        }
        this.currentBasename = PropertyUtils.interpolateWithProperties(this.settings.getTemplate(), localProps, System.getProperties());
    }

    protected String getBaseFilename() {
        String name = this.f.getName();
        if (this.settings.getCompress() && name.endsWith(".gz")) {
            return name.substring(0, name.length() - 3);
        }
        if (this.settings.getCompress() && name.endsWith(".gz.open")) {
            return name.substring(0, name.length() - (3 + ".open".length()));
        }
        return name;
    }

    public File getFile() {
        return this.f;
    }

    protected void preWriteRecordTasks() throws IOException {
        if (this.out == null) {
            this.createFile();
        }
        if (this.settings.getCompress()) {
            this.out = new CompressedStream(this.out);
        }
    }

    protected void postWriteRecordTasks() throws IOException {
        if (this.settings.getCompress()) {
            CompressedStream o = (CompressedStream)this.out;
            o.finish();
            o.flush();
            o.end();
            this.out = o.getWrappedStream();
        }
    }

    public long getPosition() {
        return this.countOut == null ? 0L : this.countOut.getCount();
    }

    public boolean isCompressed() {
        return this.settings.getCompress();
    }

    protected void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    protected void flush() throws IOException {
        this.out.flush();
    }

    protected void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    protected void write(int b) throws IOException {
        this.out.write(b);
    }

    protected long copyFrom(InputStream is, long recordLength, boolean enforceLength) throws IOException {
        long tot;
        int read = this.scratchbuffer.length;
        for (tot = 0L; tot < recordLength && (read = is.read(this.scratchbuffer)) != -1; tot += (long)read) {
            int write = read;
            write = (int)Math.min((long)write, recordLength - tot);
            this.write(this.scratchbuffer, 0, write);
        }
        if (enforceLength && tot != recordLength) {
            throw new IOException("Read " + tot + " but expected " + recordLength);
        }
        return tot;
    }

    public void close() throws IOException {
        if (this.out == null) {
            return;
        }
        this.out.close();
        this.out = null;
        if (this.f != null && this.f.exists()) {
            String path = this.f.getAbsolutePath();
            if (path.endsWith(".open")) {
                File f = new File(path.substring(0, path.length() - ".open".length()));
                if (f.exists() & !f.delete()) {
                    this.logger.warning("Failed delete of " + f);
                }
                if (!this.f.renameTo(f)) {
                    this.logger.warning("Failed rename of " + path);
                }
                this.f = f;
            }
            this.logger.fine("Closed " + this.f.getAbsolutePath() + ", size " + this.f.length());
        }
    }

    protected OutputStream getOutputStream() {
        return this.out;
    }

    private class CompressedStream
    extends GZIPOutputStream {
        public CompressedStream(OutputStream out) throws IOException {
            super(out);
        }

        OutputStream getWrappedStream() {
            return this.out;
        }

        public void end() {
            this.def.end();
        }
    }
}

