/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.webservice;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.jws.WebMethod;
import jakarta.jws.WebParam;
import jakarta.jws.WebService;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import org.apache.cxf.feature.Features;
import org.apache.openmeetings.db.dao.label.LabelDao;
import org.apache.openmeetings.db.dto.basic.ServiceResult;
import org.apache.openmeetings.db.entity.server.Sessiondata;
import org.apache.openmeetings.webservice.BaseWebService;
import org.apache.openmeetings.webservice.schema.ServiceResultWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="errorWebService")
@WebService(serviceName="org.apache.openmeetings.webservice.ErrorWebService", targetNamespace="http://webservice.openmeetings.apache.org/")
@Features(features={"org.apache.cxf.ext.logging.LoggingFeature"})
@Produces(value={"application/json"})
@Tag(name="ErrorService")
@Path(value="/error")
public class ErrorWebService
extends BaseWebService {
    private static final Logger log = LoggerFactory.getLogger(ErrorWebService.class);

    @WebMethod
    @GET
    @Path(value="/{key}/{lang}")
    @Operation(description="Loads an Error-Object. If a Method returns a negative Result, its an\n Error-id, it needs a languageId to specify in which language you want to\n display/read the error-message. English has the Language-ID one, for\n different one see the list of languages", responses={@ApiResponse(responseCode="200", description="error with the code given", content={@Content(schema=@Schema(implementation=ServiceResultWrapper.class))}), @ApiResponse(responseCode="500", description="Server error")})
    public ServiceResult get(@Parameter(required=true, description="the error key for ex. `error.unknown`") @WebParam(name="key") @PathParam(value="key") String key, @Parameter(required=true, description="The id of the language") @WebParam(name="lang") @PathParam(value="lang") long lang) {
        try {
            String eValue = LabelDao.getString((String)key, (long)lang);
            return new ServiceResult(eValue, ServiceResult.Type.SUCCESS);
        }
        catch (Exception err) {
            log.error("[get] ", (Throwable)err);
            return null;
        }
    }

    @WebMethod
    @POST
    @Path(value="/report/")
    @Operation(description="Logs an error to the log file for reporting", responses={@ApiResponse(responseCode="200", description="Success"), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public void report(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @WebParam(name="sid") @QueryParam(value="sid") String sid, @Parameter(required=true, description="The message to log") @WebParam(name="message") @QueryParam(value="message") String message) {
        Sessiondata sd;
        if (sid != null && message != null && (sd = this.check(sid)).getId() != null) {
            log.error("[CLIENT MESSAGE] {}", (Object)message);
        }
    }
}

