/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.impl.util.AutoCloseableTraverser;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class AutoCloseableTraversers {
    private static final AutoCloseableTraverser<Object> EMPTY_AUTOCLOSEABLE_TRAVERSER = new EmptyAutoCloseableTraverser<Object>();

    private AutoCloseableTraversers() {
    }

    @Nonnull
    public static <T> AutoCloseableTraverser<T> emptyAutoCloseableTraverser() {
        return EMPTY_AUTOCLOSEABLE_TRAVERSER;
    }

    @Nonnull
    public static <T> AutoCloseableTraverser<T> traverseAutoCloseableIterator(final @Nonnull Iterator<? extends T> iterator) {
        return new AutoCloseableTraverser<T>(){

            @Override
            public T next() {
                return iterator.hasNext() ? (Object)Objects.requireNonNull(iterator.next(), "Iterator returned a null item") : null;
            }

            @Override
            public void close() throws Exception {
                if (iterator instanceof AutoCloseable) {
                    AutoCloseable autoCloseable = (AutoCloseable)((Object)iterator);
                    autoCloseable.close();
                }
            }
        };
    }

    private static final class EmptyAutoCloseableTraverser<T>
    implements AutoCloseableTraverser<T> {
        private EmptyAutoCloseableTraverser() {
        }

        @Override
        public T next() {
            return null;
        }

        @Override
        @Nonnull
        public <R> Traverser<R> map(@Nonnull Function<? super T, ? extends R> mapFn) {
            return this;
        }

        @Override
        @Nonnull
        public <R> Traverser<R> flatMap(@Nonnull Function<? super T, ? extends Traverser<R>> flatMapFn) {
            return this;
        }

        @Override
        @Nonnull
        public Traverser<T> filter(@Nonnull Predicate<? super T> filterFn) {
            return this;
        }

        @Override
        @Nonnull
        public Traverser<T> takeWhile(@Nonnull Predicate<? super T> predicate) {
            return this;
        }

        @Override
        @Nonnull
        public Traverser<T> dropWhile(@Nonnull Predicate<? super T> predicate) {
            return this;
        }

        @Override
        @Nonnull
        public Traverser<T> peek(@Nonnull Consumer<? super T> action) {
            return this;
        }
    }
}

