/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution.init;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.util.collection.Int2ObjectHashMap;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.impl.execution.init.EdgeDef;
import com.hazelcast.jet.impl.execution.init.VertexDef;
import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

class DagNodeUtil {
    private final Address localAddress;
    private final BitSet localVertices;
    private final Map<String, Set<Address>> targets = new HashMap<String, Set<Address>>();
    private final Map<String, Set<Address>> sources = new HashMap<String, Set<Address>>();

    DagNodeUtil(List<VertexDef> vertices, Set<Address> allAddresses, Address localAddress) {
        this.localAddress = localAddress;
        Int2ObjectHashMap<Set<Address>> vertexOnAddress = new Int2ObjectHashMap<Set<Address>>();
        HashMap<String, Set<Connection>> edgesToConnections = new HashMap<String, Set<Connection>>();
        ArrayDeque<VertexDef> queue = new ArrayDeque<VertexDef>(vertices.size());
        BitSet visited = new BitSet(vertices.size());
        for (VertexDef vertex : vertices) {
            if (vertex.inboundEdges().isEmpty()) {
                vertexOnAddress.put(vertex.vertexId(), allAddresses);
                queue.add(vertex);
                continue;
            }
            vertexOnAddress.put(vertex.vertexId(), (Set<Address>)new HashSet());
        }
        while (!queue.isEmpty()) {
            VertexDef current = (VertexDef)queue.poll();
            visited.set(current.vertexId());
            Set<Address> currentVertexAddresses = vertexOnAddress.get(current.vertexId());
            for (EdgeDef outboundEdge : current.outboundEdges()) {
                this.traverse(outboundEdge, currentVertexAddresses, allAddresses, vertexOnAddress, edgesToConnections);
                if (!this.allSourcesVisited(outboundEdge.destVertex(), visited) || visited.get(outboundEdge.destVertex().vertexId())) continue;
                queue.add(outboundEdge.destVertex());
            }
        }
        this.localVertices = new BitSet(vertices.size());
        this.populateFields(vertexOnAddress, edgesToConnections);
    }

    private void populateFields(Int2ObjectHashMap<Set<Address>> vertexOnAddress, Map<String, Set<Connection>> edgesToConnections) {
        for (Map.Entry<Integer, Set<Address>> entry : vertexOnAddress.entrySet()) {
            if (!entry.getValue().contains(this.localAddress)) continue;
            this.localVertices.set(entry.getKey());
        }
        for (String string : edgesToConnections.keySet()) {
            this.sources.put(string, new HashSet());
            this.targets.put(string, new HashSet());
        }
        for (Map.Entry entry : edgesToConnections.entrySet()) {
            for (Connection connection : (Set)entry.getValue()) {
                if (connection.isTo(this.localAddress)) {
                    this.sources.computeIfAbsent((String)entry.getKey(), x -> new HashSet()).add(connection.from);
                }
                if (!connection.isFrom(this.localAddress)) continue;
                this.targets.computeIfAbsent((String)entry.getKey(), x -> new HashSet()).add(connection.to);
            }
        }
    }

    private void traverse(EdgeDef outboundEdge, Set<Address> currentVertexAddresses, Set<Address> allAddresses, Int2ObjectHashMap<Set<Address>> vertexOnAddress, Map<String, Set<Connection>> edgesToConnections) {
        Set connections = edgesToConnections.computeIfAbsent(outboundEdge.edgeId(), edgeDef -> new HashSet());
        if (outboundEdge.isLocal()) {
            for (Address address : currentVertexAddresses) {
                connections.add(new Connection(address, address));
                Set<Address> addresses = vertexOnAddress.get(outboundEdge.destVertex().vertexId());
                if (addresses.size() == allAddresses.size()) continue;
                addresses.add(address);
            }
        } else if (outboundEdge.getDistributedTo().equals(Edge.DISTRIBUTE_TO_ALL)) {
            for (Address sourceAddress : currentVertexAddresses) {
                for (Address targetAddress : allAddresses) {
                    connections.add(new Connection(sourceAddress, targetAddress));
                }
            }
            vertexOnAddress.put(outboundEdge.destVertex().vertexId(), allAddresses);
        } else {
            for (Address address : currentVertexAddresses) {
                connections.add(new Connection(address, outboundEdge.getDistributedTo()));
            }
            Set<Address> addresses = vertexOnAddress.get(outboundEdge.destVertex().vertexId());
            if (addresses.size() != allAddresses.size()) {
                addresses.add(outboundEdge.getDistributedTo());
            }
        }
    }

    private boolean allSourcesVisited(VertexDef current, BitSet visited) {
        for (EdgeDef inboundEdge : current.inboundEdges()) {
            if (visited.get(inboundEdge.sourceVertex().vertexId())) continue;
            return false;
        }
        return true;
    }

    Set<Address> getEdgeTargets(EdgeDef edge) {
        return this.targets.get(edge.edgeId());
    }

    Set<Address> getEdgeSources(EdgeDef edge) {
        return this.sources.get(edge.edgeId());
    }

    boolean vertexExists(VertexDef vertex) {
        return this.localVertices.get(vertex.vertexId());
    }

    int numRemoteSources(EdgeDef edge) {
        Set<Address> edgeSources = this.sources.get(edge.edgeId());
        return edgeSources.contains(this.localAddress) ? edgeSources.size() - 1 : edgeSources.size();
    }

    private static class Connection {
        final Address from;
        final Address to;
        private final int hashCode;

        Connection(Address from, Address to) {
            this.from = from;
            this.to = to;
            this.hashCode = Objects.hash(from, to);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Connection that = (Connection)o;
            return this.hashCode == that.hashCode && Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to);
        }

        boolean isFrom(Address from) {
            return from.equals(this.from);
        }

        boolean isTo(Address to) {
            return to.equals(this.to);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

