/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import java.util.function.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessagePayload;
import org.apache.pulsar.client.api.MessagePayloadContext;
import org.apache.pulsar.client.api.Schema;

public interface MessagePayloadProcessor {
    public static final MessagePayloadProcessor DEFAULT = new MessagePayloadProcessor(){

        @Override
        public <T> void process(MessagePayload payload, MessagePayloadContext context, Schema<T> schema, Consumer<Message<T>> messageConsumer) {
            if (context.isBatch()) {
                int numMessages = context.getNumMessages();
                for (int i = 0; i < numMessages; ++i) {
                    messageConsumer.accept(context.getMessageAt(i, numMessages, payload, true, schema));
                }
            } else {
                messageConsumer.accept(context.asSingleMessage(payload, schema));
            }
        }
    };

    public <T> void process(MessagePayload var1, MessagePayloadContext var2, Schema<T> var3, Consumer<Message<T>> var4) throws Exception;
}

