/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.provider.pojo.reference;

import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.foundation.common.utils.ReflectUtils;
import org.apache.servicecomb.provider.pojo.reference.PojoReferenceMeta;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class ReferenceDefParser
extends AbstractSingleBeanDefinitionParser {
    protected Class<?> getBeanClass(Element element) {
        return PojoReferenceMeta.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Class consumerIntf;
        builder.addPropertyValue("microserviceName", (Object)element.getAttribute("microservice-name"));
        String schemaId = element.getAttribute("schema-id");
        String intf = element.getAttribute("interface");
        if (StringUtils.isEmpty((CharSequence)intf) && StringUtils.isNotEmpty((CharSequence)schemaId) && (consumerIntf = ReflectUtils.getClassByName((String)schemaId)) != null) {
            intf = schemaId;
        }
        builder.addPropertyValue("schemaId", (Object)schemaId);
        builder.addPropertyValue("consumerIntf", (Object)intf);
        if (StringUtils.isEmpty((CharSequence)schemaId) && StringUtils.isEmpty((CharSequence)intf)) {
            throw new Error("schema-id and interface can not both be empty.");
        }
    }
}

