/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.provider.consumer;

import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.provider.consumer.ReferenceConfig;

public class MicroserviceReferenceConfig {
    private final String appId;
    private final String microserviceName;
    private final MicroserviceMeta microserviceMeta;

    public MicroserviceReferenceConfig(String appId, String microserviceName, MicroserviceMeta microserviceMeta) {
        this.appId = appId;
        this.microserviceName = microserviceName;
        this.microserviceMeta = microserviceMeta;
    }

    public MicroserviceMeta getMicroserviceMeta() {
        if (this.microserviceMeta == null) {
            throw new IllegalStateException(String.format("Probably invoke a service before it is registered, or no instance found for it, appId=%s, name=%s.", this.appId, this.microserviceName));
        }
        return this.microserviceMeta;
    }

    public ReferenceConfig createReferenceConfig(OperationMeta operationMeta) {
        return this.createReferenceConfig(null, operationMeta);
    }

    public ReferenceConfig createReferenceConfig(String transport, OperationMeta operationMeta) {
        if (transport == null) {
            transport = operationMeta.getConfig().getTransport();
        }
        ReferenceConfig referenceConfig = new ReferenceConfig(transport);
        return referenceConfig;
    }
}

