/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.internal;

import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.sis.util.internal.shared.Numerics;

public final class AutoMessageFormat
extends MessageFormat {
    private transient NumberFormat[] formatsToConfigure;
    private transient boolean update;

    public AutoMessageFormat(String pattern) {
        super(pattern);
    }

    public AutoMessageFormat(String pattern, Locale locale) {
        super(pattern, locale);
    }

    @Override
    public void applyPattern(String pattern) {
        super.applyPattern(pattern);
        this.update = true;
    }

    public void configure(Object[] arguments) {
        if (this.update) {
            this.formatsToConfigure = null;
            Format[] fc = this.getFormatsByArgumentIndex();
            int i = fc.length;
            while (--i >= 0) {
                Format c = fc[i];
                if (!(c instanceof NumberFormat)) continue;
                if (this.formatsToConfigure == null) {
                    this.formatsToConfigure = new NumberFormat[i + 1];
                }
                this.formatsToConfigure[i] = (NumberFormat)c;
            }
        }
        if (this.formatsToConfigure != null) {
            int i = Math.min(this.formatsToConfigure.length, arguments.length);
            while (--i >= 0) {
                double n;
                NumberFormat f = this.formatsToConfigure[i];
                if (f == null) continue;
                Object value = arguments[i];
                int p = 3;
                if (value instanceof Number && !Double.isNaN(n = ((Number)value).doubleValue())) {
                    p = -1 - Numerics.toExp10(Math.getExponent(Math.ulp(n)));
                }
                f.setMaximumFractionDigits(Math.min(p, 16));
            }
        }
    }
}

