/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.impl.vlt;

import java.math.BigDecimal;
import java.util.Calendar;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;

public abstract class ConversionUtils {
    public static Object getPropertyValue(Property property) throws RepositoryException {
        Object propertyValue = null;
        switch (property.getType()) {
            case 6: {
                if (property.isMultiple()) {
                    propertyValue = ConversionUtils.toBooleanArray(property.getValues());
                    break;
                }
                propertyValue = property.getBoolean();
                break;
            }
            case 5: {
                if (property.isMultiple()) {
                    propertyValue = ConversionUtils.toCalendarArray(property.getValues());
                    break;
                }
                propertyValue = property.getDate();
                break;
            }
            case 12: {
                if (property.isMultiple()) {
                    propertyValue = ConversionUtils.toDecimalArray(property.getValues());
                    break;
                }
                propertyValue = property.getDecimal();
                break;
            }
            case 4: {
                if (property.isMultiple()) {
                    propertyValue = ConversionUtils.toDoubleArray(property.getValues());
                    break;
                }
                propertyValue = property.getDouble();
                break;
            }
            case 3: {
                if (property.isMultiple()) {
                    propertyValue = ConversionUtils.toLongArray(property.getValues());
                    break;
                }
                propertyValue = property.getLong();
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                if (property.isMultiple()) {
                    propertyValue = ConversionUtils.toStringArray(property.getValues());
                    break;
                }
                propertyValue = property.getString();
                break;
            }
            case 2: {
                break;
            }
        }
        return propertyValue;
    }

    private static String[] toStringArray(Value[] values) throws RepositoryException {
        String[] ret = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            ret[i] = values[i].getString();
        }
        return ret;
    }

    private static Boolean[] toBooleanArray(Value[] values) throws RepositoryException {
        Boolean[] ret = new Boolean[values.length];
        for (int i = 0; i < values.length; ++i) {
            ret[i] = values[i].getBoolean();
        }
        return ret;
    }

    private static Calendar[] toCalendarArray(Value[] values) throws RepositoryException {
        Calendar[] ret = new Calendar[values.length];
        for (int i = 0; i < values.length; ++i) {
            ret[i] = values[i].getDate();
        }
        return ret;
    }

    private static BigDecimal[] toDecimalArray(Value[] values) throws RepositoryException {
        BigDecimal[] ret = new BigDecimal[values.length];
        for (int i = 0; i < values.length; ++i) {
            ret[i] = values[i].getDecimal();
        }
        return ret;
    }

    private static Double[] toDoubleArray(Value[] values) throws RepositoryException {
        Double[] ret = new Double[values.length];
        for (int i = 0; i < values.length; ++i) {
            ret[i] = values[i].getDouble();
        }
        return ret;
    }

    private static Long[] toLongArray(Value[] values) throws RepositoryException {
        Long[] ret = new Long[values.length];
        for (int i = 0; i < values.length; ++i) {
            ret[i] = values[i].getLong();
        }
        return ret;
    }

    private ConversionUtils() {
    }
}

