/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.setuid;

import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.setuid.Group;
import org.eclipse.jetty.setuid.Passwd;
import org.eclipse.jetty.setuid.RLimit;
import org.eclipse.jetty.setuid.internal.LibC;
import org.eclipse.jetty.util.component.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetUIDListener
implements LifeCycle.Listener {
    private static final Logger LOG = LoggerFactory.getLogger(SetUIDListener.class);
    private int _uid = 0;
    private int _gid = 0;
    private int _umask = -1;
    private boolean _startServerAsPrivileged;
    private boolean _clearSupplementalGroups;
    private RLimit _rlimitNoFiles = null;

    public void setUsername(String username) {
        Passwd passwd = LibC.INSTANCE.getpwnam(username);
        this._uid = passwd.getPwUid();
    }

    public String getUsername() {
        Passwd passwd = LibC.INSTANCE.getpwuid(this._uid);
        return passwd.getPwName();
    }

    public void setGroupname(String groupname) {
        Group group = LibC.INSTANCE.getgrnam(groupname);
        this._gid = group.getGrGid();
    }

    public String getGroupname() {
        Group group = LibC.INSTANCE.getgrgid(this._gid);
        return group.getGrName();
    }

    public int getUmask() {
        return this._umask;
    }

    public String getUmaskOctal() {
        return Integer.toOctalString(this._umask);
    }

    public void setUmask(int umask) {
        this._umask = umask;
    }

    public void setUmaskOctal(String umask) {
        this._umask = Integer.parseInt(umask, 8);
    }

    public int getUid() {
        return this._uid;
    }

    public void setUid(int uid) {
        this._uid = uid;
    }

    public void setGid(int gid) {
        this._gid = gid;
    }

    public int getGid() {
        return this._gid;
    }

    public void setRLimitNoFiles(RLimit rlimit) {
        this._rlimitNoFiles = rlimit;
    }

    public RLimit getRLimitNoFiles() {
        return this._rlimitNoFiles;
    }

    public boolean isClearSupplementalGroups() {
        return this._clearSupplementalGroups;
    }

    public void setClearSupplementalGroups(boolean clearSupplementalGroups) {
        this._clearSupplementalGroups = clearSupplementalGroups;
    }

    protected void setGidUid() {
        if (this._gid != 0) {
            if (this.isClearSupplementalGroups()) {
                LOG.info("Clearing supplemental groups");
                LibC.INSTANCE.setgroups(new int[0]);
            }
            LOG.info("Setting GID={}", (Object)this._gid);
            LibC.INSTANCE.setgid(this._gid);
        }
        if (this._uid != 0) {
            LOG.info("Setting UID={}", (Object)this._uid);
            LibC.INSTANCE.setuid(this._uid);
            Passwd pw = LibC.INSTANCE.getpwuid(this._uid);
            System.setProperty("user.name", pw.getPwName());
            System.setProperty("user.home", pw.getPwDir());
        }
    }

    public void lifeCycleFailure(LifeCycle lifecycle, Throwable cause) {
    }

    public void lifeCycleStarted(LifeCycle lifecycle) {
        if (this._startServerAsPrivileged) {
            this.setGidUid();
        }
    }

    public void lifeCycleStarting(LifeCycle lifecycle) {
        String jettyUserEnvVariable = System.getenv("JETTY_USER");
        if (jettyUserEnvVariable != null) {
            LOG.warn("JETTY_USER set to: {}. If JETTY_USER is set, starting jetty as root and using jetty-setuid to switch user won't work!!!", (Object)jettyUserEnvVariable);
        }
        if (this._umask > -1) {
            LOG.info("Setting umask=0{}", (Object)Integer.toString(this._umask, 8));
            LibC.INSTANCE.umask(this._umask);
        }
        if (this._rlimitNoFiles != null) {
            if (LibC.Constants.RLIMIT_NOFILE == Integer.MIN_VALUE) {
                LOG.warn("rlimitNoFiles cannot be set on unsupported platform, ignoring configured values: " + this._rlimitNoFiles);
            } else {
                RLimit temp = new RLimit();
                LibC.INSTANCE.getrlimit(LibC.Constants.RLIMIT_NOFILE, temp);
                LOG.info("Current {}", (Object)temp);
                int success = LibC.INSTANCE.setrlimit(LibC.Constants.RLIMIT_NOFILE, this._rlimitNoFiles);
                if (success < 0) {
                    LOG.warn("Failed to set rlimit_nofiles, returned status {}", (Object)success);
                }
                LibC.INSTANCE.getrlimit(LibC.Constants.RLIMIT_NOFILE, temp);
                LOG.info("Set {}", (Object)temp);
            }
        }
        if (this._startServerAsPrivileged) {
            return;
        }
        try {
            Connector[] connectors;
            LifeCycle tplc;
            Server server = (Server)lifecycle;
            if (server.getThreadPool() instanceof LifeCycle && !(tplc = (LifeCycle)server.getThreadPool()).isRunning()) {
                server.manage((Object)tplc);
                tplc.start();
            }
            if ((connectors = server.getConnectors()) != null) {
                for (Connector connector : connectors) {
                    if (connector instanceof NetworkConnector) {
                        ((NetworkConnector)connector).open();
                        LOG.info("Opened {}", (Object)connector);
                        continue;
                    }
                    if (connector.isRunning()) continue;
                    server.manage((Object)connector);
                    connector.start();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.setGidUid();
    }

    public void lifeCycleStopped(LifeCycle ignore) {
    }

    public void lifeCycleStopping(LifeCycle ignore) {
    }

    public boolean isStartServerAsPrivileged() {
        return this._startServerAsPrivileged;
    }

    public void setStartServerAsPrivileged(boolean startContextsAsPrivileged) {
        this._startServerAsPrivileged = startContextsAsPrivileged;
    }
}

