/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.common.servlet;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

class TeeServletInputStream
extends ServletInputStream {
    InputStream in;
    byte[] inputBuffer;

    TeeServletInputStream(HttpServletRequest request) {
        this.duplicateInputStream(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void duplicateInputStream(HttpServletRequest request) {
        ServletInputStream originalSIS = null;
        try {
            originalSIS = request.getInputStream();
            this.inputBuffer = this.consumeBufferAndReturnAsByteArray((InputStream)originalSIS);
            this.in = new ByteArrayInputStream(this.inputBuffer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.closeStream(originalSIS);
        }
    }

    public int read() throws IOException {
        return this.in.read();
    }

    byte[] consumeBufferAndReturnAsByteArray(InputStream is) throws IOException {
        int len = 1024;
        byte[] temp = new byte[len];
        int c = -1;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((c = is.read(temp, 0, len)) != -1) {
            baos.write(temp, 0, c);
        }
        return baos.toByteArray();
    }

    void closeStream(ServletInputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    byte[] getInputBuffer() {
        return this.inputBuffer;
    }

    public boolean isFinished() {
        throw new RuntimeException("Not yet implemented");
    }

    public boolean isReady() {
        throw new RuntimeException("Not yet implemented");
    }

    public void setReadListener(ReadListener listener) {
        throw new RuntimeException("Not yet implemented");
    }
}

