/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis;

import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.export.LengthUtil;
import net.sf.jasperreports.engine.export.oasis.Style;
import net.sf.jasperreports.engine.export.oasis.WriterHelper;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;

public class GraphicStyle
extends Style {
    public static final Double DPI_RATIO = 0.75;
    private String backcolor;
    private String forecolor;
    private String style;
    private double width;
    private String hAlign;
    private String vAlign;
    private double cropTop;
    private double cropLeft;
    private double cropBottom;
    private double cropRight;
    private String clip;

    public GraphicStyle(WriterHelper styleWriter, JRPrintGraphicElement element, double cropTop, double cropLeft, double cropBottom, double cropRight) {
        super(styleWriter);
        this.cropTop = cropTop;
        this.cropLeft = cropLeft;
        this.cropBottom = cropBottom;
        this.cropRight = cropRight;
        if (element.getMode() == ModeEnum.OPAQUE) {
            this.backcolor = JRColorUtil.getColorHexa(element.getBackcolor());
        }
        this.forecolor = JRColorUtil.getColorHexa(element.getLinePen().getLineColor());
        this.width = element.getLinePen().getLineWidth().floatValue();
        if (this.width <= 0.0) {
            this.style = "none";
        } else {
            switch (element.getLinePen().getLineStyle()) {
                case DOTTED: 
                case DASHED: {
                    this.style = "dash";
                    break;
                }
                default: {
                    this.style = "solid";
                }
            }
        }
        if (element instanceof JRPrintImage) {
            this.clip = " fo:clip=\"rect(" + LengthUtil.inchFloor4Dec(cropTop * DPI_RATIO) + "in," + LengthUtil.inchFloor4Dec(cropRight * DPI_RATIO) + "in," + LengthUtil.inchFloor4Dec(cropBottom * DPI_RATIO) + "in," + LengthUtil.inchFloor4Dec(cropLeft * DPI_RATIO) + "in)\"";
        }
    }

    @Override
    public String getId() {
        StringBuilder id = new StringBuilder();
        id.append(this.backcolor);
        id.append("|");
        id.append(this.forecolor);
        id.append("|");
        id.append(this.style);
        id.append("|");
        id.append(this.width);
        id.append("|");
        id.append(this.hAlign);
        id.append("|");
        id.append(this.vAlign);
        id.append("|");
        id.append(this.cropTop);
        id.append("|");
        id.append(this.cropLeft);
        id.append("|");
        id.append(this.cropBottom);
        id.append("|");
        id.append(this.cropRight);
        return id.toString();
    }

    @Override
    public void write(String lineStyleName) {
        this.styleWriter.write(" <style:style style:name=\"" + lineStyleName + "\"");
        this.styleWriter.write(" style:family=\"graphic\" style:parent-style-name=\"Graphics\">\n");
        this.styleWriter.write("   <style:graphic-properties");
        if (this.backcolor != null) {
            this.styleWriter.write(" draw:fill-color=\"#" + this.backcolor + "\"");
        }
        this.styleWriter.write(" style:horizontal-pos=\"from-left\" style:horizontal-rel=\"frame\"");
        this.styleWriter.write(" style:vertical-pos=\"from-top\" style:vertical-rel=\"frame\"");
        if (this.clip != null) {
            this.styleWriter.write(this.clip);
        }
        this.styleWriter.write(" svg:stroke-color=\"#" + this.forecolor + "\"");
        this.styleWriter.write(" draw:stroke=\"" + this.style + "\"");
        this.styleWriter.write(" draw:stroke-dash=\"Dashed\"");
        this.styleWriter.write(" svg:stroke-width=\"" + LengthUtil.inchFloor4Dec(this.width) + "in\"");
        this.styleWriter.write("/>\n");
        this.styleWriter.write("</style:style>\n");
    }
}

