/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.controlprogram.caching.FrameObject;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.caching.TensorObject;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.ListObject;
import org.apache.sysds.runtime.io.FileFormatProperties;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.MetaDataAll;
import org.apache.sysds.runtime.meta.MetaDataFormat;
import org.apache.sysds.runtime.util.HDFSTool;

public class ListReader {
    public static ListObject readListFromHDFS(String fname, String fmtStr, FileFormatProperties props) throws DMLRuntimeException {
        MetaDataAll meta = new MetaDataAll(fname + ".mtd", false, true);
        int numObjs = (int)meta.getDim1();
        boolean named = false;
        Data[] data = null;
        String[] names = null;
        try {
            Path dirPath = new Path(fname);
            JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
            FileSystem fs = IOUtilFunctions.getFileSystem(dirPath, (Configuration)job);
            Path[] mtdFiles = IOUtilFunctions.getMetadataFilePaths(fs, dirPath);
            if (numObjs != mtdFiles.length) {
                throw new DMLRuntimeException("List meta data does not match available mtd files: " + numObjs + " vs " + mtdFiles.length);
            }
            named = Arrays.stream(mtdFiles).map(p -> p.toString()).anyMatch(s -> !s.substring(s.lastIndexOf(95)).equals("null"));
            data = new Data[numObjs];
            names = named ? new String[numObjs] : null;
            for (int i = 0; i < numObjs; ++i) {
                MetaDataAll lmeta = new MetaDataAll(mtdFiles[i].toString(), false, true);
                String lfname = lmeta.getFilename().substring(0, lmeta.getFilename().length() - 4);
                DataCharacteristics dc = lmeta.getDataCharacteristics();
                Types.FileFormat fmt = lmeta.getFileFormat();
                Data dat = null;
                switch (lmeta.getDataType()) {
                    case MATRIX: {
                        dat = new MatrixObject(lmeta.getValueType(), lfname);
                        break;
                    }
                    case TENSOR: {
                        dat = new TensorObject(lmeta.getValueType(), lfname);
                        break;
                    }
                    case FRAME: {
                        dat = new FrameObject(lfname);
                        if (lmeta.getSchema() == null) break;
                        ((FrameObject)dat).setSchema(lmeta.getSchema());
                        break;
                    }
                    case LIST: {
                        dat = ListReader.readListFromHDFS(lfname, fmt.toString(), props);
                        break;
                    }
                    case SCALAR: {
                        dat = HDFSTool.readScalarObjectFromHDFSFile(lfname, lmeta.getValueType());
                        break;
                    }
                    default: {
                        throw new DMLRuntimeException("Unexpected data type: " + lmeta.getDataType());
                    }
                }
                if (dat instanceof CacheableData) {
                    ((CacheableData)dat).setMetaData(new MetaDataFormat(dc, fmt));
                    ((CacheableData)dat).enableCleanup(false);
                }
                String[] parts = lfname.substring(lfname.lastIndexOf("/") + 1).split("_");
                data[Integer.parseInt((String)parts[0])] = dat;
                if (!named) continue;
                names[Integer.parseInt((String)parts[0])] = parts[1];
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException("Failed to write list object of length " + numObjs + ".", ex);
        }
        return named ? new ListObject(data, names) : new ListObject(data);
    }
}

