/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.iogen.template;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.io.MatrixReader;
import org.apache.sysds.runtime.iogen.CustomProperties;
import org.apache.sysds.runtime.iogen.RowIndexStructure;
import org.apache.sysds.runtime.iogen.template.TemplateUtil;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.Pair;
import org.apache.sysds.runtime.util.CommonThreadPool;

public abstract class MatrixGenerateReaderParallel
extends MatrixReader {
    protected static CustomProperties _props;
    protected int _numThreads = OptimizerUtils.getParallelTextReadParallelism();
    protected JobConf job;
    protected TemplateUtil.SplitOffsetInfos _offsets;
    protected int _rLen;
    protected int _cLen;

    public MatrixGenerateReaderParallel(CustomProperties _props) {
        MatrixGenerateReaderParallel._props = _props;
    }

    @Override
    public MatrixBlock readMatrixFromHDFS(String fname, long rlen, long clen, int blen, long estnnz) throws IOException, DMLRuntimeException {
        this.job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)this.job);
        FileInputFormat.addInputPath((JobConf)this.job, (Path)path);
        TextInputFormat informat = new TextInputFormat();
        informat.configure(this.job);
        InputSplit[] splits = informat.getSplits(this.job, this._numThreads);
        splits = IOUtilFunctions.sortInputSplits(splits);
        MatrixGenerateReaderParallel.checkValidInputFile(fs, path);
        MatrixBlock ret = this.computeSizeAndCreateOutputMatrixBlock(splits, path, rlen, _props.getNcols(), blen, estnnz);
        this.readMatrixFromHDFS(informat, splits, path, this.job, ret, rlen, clen, blen);
        return ret;
    }

    private MatrixBlock computeSizeAndCreateOutputMatrixBlock(InputSplit[] splits, Path path, long rlen, long clen, int blen, long estnnz) throws IOException, DMLRuntimeException {
        long estnnz2;
        block19: {
            this._rLen = 0;
            this._cLen = _props.getNcols();
            FileInputFormat.addInputPath((JobConf)this.job, (Path)path);
            TextInputFormat informat = new TextInputFormat();
            informat.configure(this.job);
            estnnz2 = -1L;
            ExecutorService pool = CommonThreadPool.get(this._numThreads);
            try {
                if (_props.getRowIndexStructure().getProperties() == RowIndexStructure.IndexProperties.Identity) {
                    ArrayList<IOUtilFunctions.CountRowsTask> tasks = new ArrayList<IOUtilFunctions.CountRowsTask>();
                    for (InputSplit split : splits) {
                        tasks.add(new IOUtilFunctions.CountRowsTask(split, informat, this.job, false));
                    }
                    this._offsets = new TemplateUtil.SplitOffsetInfos(tasks.size());
                    int i = 0;
                    for (Future rc : pool.invokeAll(tasks)) {
                        int lnrow = (int)((Long)rc.get()).longValue();
                        this._offsets.setOffsetPerSplit(i, this._rLen);
                        this._offsets.setLenghtPerSplit(i, lnrow);
                        this._rLen += lnrow;
                        ++i;
                    }
                    estnnz2 = estnnz < 0L ? (long)this._rLen * (long)this._cLen : estnnz;
                    break block19;
                }
                if (_props.getRowIndexStructure().getProperties() == RowIndexStructure.IndexProperties.CellWiseExist || _props.getRowIndexStructure().getProperties() == RowIndexStructure.IndexProperties.RowWiseExist) {
                    if (rlen >= 0L) {
                        this._rLen = (int)rlen;
                        this._offsets = new TemplateUtil.SplitOffsetInfos(splits.length);
                        for (int i = 0; i < splits.length; ++i) {
                            this._offsets.setOffsetPerSplit(i, this._rLen);
                            this._offsets.setLenghtPerSplit(i, this._rLen);
                        }
                    } else {
                        ArrayList<CountCellRowsTask> tasks = new ArrayList<CountCellRowsTask>();
                        for (InputSplit split : splits) {
                            tasks.add(new CountCellRowsTask(split, informat, this.job));
                        }
                        this._offsets = new TemplateUtil.SplitOffsetInfos(tasks.size());
                        int i = 0;
                        this._rLen = 0;
                        for (Future rc : pool.invokeAll(tasks)) {
                            int lnrow = ((TemplateUtil.SplitInfo)rc.get()).getNrows();
                            this._offsets.setOffsetPerSplit(i, this._rLen);
                            this._offsets.setLenghtPerSplit(i, lnrow);
                            this._rLen = Math.max(lnrow, this._rLen);
                            ++i;
                        }
                    }
                    estnnz2 = -1L;
                    break block19;
                }
                if (_props.getRowIndexStructure().getProperties() == RowIndexStructure.IndexProperties.SeqScatter) {
                    ArrayList<CountSeqScatteredRowsTask> tasks = new ArrayList<CountSeqScatteredRowsTask>();
                    for (InputSplit split : splits) {
                        tasks.add(new CountSeqScatteredRowsTask(split, informat, this.job, _props.getRowIndexStructure().getSeqBeginString(), _props.getRowIndexStructure().getSeqEndString()));
                    }
                    this._offsets = new TemplateUtil.SplitOffsetInfos(tasks.size());
                    int i = 0;
                    for (Future rc : pool.invokeAll(tasks)) {
                        TemplateUtil.SplitInfo splitInfo = (TemplateUtil.SplitInfo)rc.get();
                        this._offsets.setSeqOffsetPerSplit(i, splitInfo);
                        this._offsets.setOffsetPerSplit(i, this._rLen);
                        this._rLen += splitInfo.getNrows();
                        ++i;
                    }
                    estnnz2 = estnnz < 0L ? (long)this._rLen * (long)this._cLen : estnnz;
                }
            }
            catch (Exception e) {
                throw new IOException("Thread pool Error " + e.getMessage(), e);
            }
            finally {
                pool.shutdown();
            }
        }
        if (rlen != -1L && (long)this._rLen != rlen) {
            String msg = "Read matrix dimensions differ from meta data: [" + this._rLen + "x" + this._cLen + "] vs. [" + rlen + "x" + clen + "].";
            if (rlen < (long)this._rLen || clen < (long)this._cLen) {
                throw new DMLRuntimeException(msg);
            }
            LOG.warn((Object)msg);
            this._rLen = (int)rlen;
            this._cLen = (int)clen;
        }
        return MatrixGenerateReaderParallel.createOutputMatrixBlock(this._rLen, this._cLen, this._rLen, estnnz2, true, false);
    }

    @Override
    public MatrixBlock readMatrixFromInputStream(InputStream is, long rlen, long clen, int blen, long estnnz) throws IOException, DMLRuntimeException {
        MatrixBlock ret = null;
        if (rlen >= 0L && clen >= 0L) {
            ret = MatrixGenerateReaderParallel.createOutputMatrixBlock(rlen, clen, (int)rlen, estnnz, true, false);
        }
        return ret;
    }

    private void readMatrixFromHDFS(TextInputFormat informat, InputSplit[] splits, Path path, JobConf job, MatrixBlock dest, long rlen, long clen, int blen) throws IOException {
        ExecutorService pool = CommonThreadPool.get(this._numThreads);
        try {
            ArrayList<ReadTask> tasks = new ArrayList<ReadTask>();
            int splitCount = 0;
            for (InputSplit split : splits) {
                tasks.add(new ReadTask(split, informat, dest, splitCount++));
            }
            CommonThreadPool.invokeAndShutdown(pool, tasks);
            long lnnz = 0L;
            for (ReadTask rt : tasks) {
                lnnz += rt.getNnz();
            }
            dest.setNonZeros(lnnz);
        }
        catch (Exception e) {
            throw new IOException("Threadpool issue, while parallel read.", e);
        }
    }

    protected abstract long readMatrixFromHDFS(RecordReader<LongWritable, Text> var1, LongWritable var2, Text var3, MatrixBlock var4, MutableInt var5, TemplateUtil.SplitInfo var6) throws IOException;

    private static class CountCellRowsTask
    implements Callable<TemplateUtil.SplitInfo> {
        private final InputSplit _split;
        private final TextInputFormat _inputFormat;
        private final JobConf _jobConf;

        public CountCellRowsTask(InputSplit split, TextInputFormat inputFormat, JobConf jobConf) {
            this._split = split;
            this._inputFormat = inputFormat;
            this._jobConf = jobConf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TemplateUtil.SplitInfo call() throws Exception {
            int mxRow;
            TemplateUtil.SplitInfo splitInfo;
            block11: {
                splitInfo = new TemplateUtil.SplitInfo();
                mxRow = 0;
                RecordReader reader = this._inputFormat.getRecordReader(this._split, this._jobConf, Reporter.NULL);
                LongWritable key = new LongWritable();
                Text value = new Text();
                try {
                    if (_props.getRowIndexStructure().getKeyPattern().size() == 1) {
                        if (_props.getRowIndexStructure().getKeyPattern().get(0).length() != 0) break block11;
                        while (reader.next((Object)key, (Object)value)) {
                            int rowValue;
                            String strValue = value.toString();
                            int endPos = TemplateUtil.getEndPos(strValue, strValue.length(), 0, _props.getRowIndexStructure().endWithValueString());
                            try {
                                rowValue = Integer.parseInt(strValue.substring(0, endPos));
                            }
                            catch (Exception ex) {
                                rowValue = 0;
                            }
                            mxRow = Math.max(mxRow, rowValue);
                        }
                        break block11;
                    }
                    while (reader.next((Object)key, (Object)value)) {
                        int rowValue;
                        String strValue = value.toString();
                        int index = 0;
                        for (int i = 0; i < _props.getRowIndexStructure().getKeyPattern().size() && index != -1; ++i) {
                            index = strValue.indexOf(_props.getRowIndexStructure().getKeyPattern().get(i), index);
                        }
                        if (index == -1) continue;
                        int endPos = TemplateUtil.getEndPos(strValue, strValue.length(), _props.getRowIndexStructure().getKeyPattern().get(_props.getRowIndexStructure().getKeyPattern().size() - 1).length() + index, _props.getRowIndexStructure().endWithValueString());
                        try {
                            rowValue = Integer.parseInt(strValue.substring(0, endPos));
                        }
                        catch (Exception ex) {
                            rowValue = 0;
                        }
                        mxRow = Math.max(mxRow, rowValue);
                    }
                }
                finally {
                    IOUtilFunctions.closeSilently(reader);
                }
            }
            splitInfo.setNrows(mxRow);
            return splitInfo;
        }
    }

    private static class CountSeqScatteredRowsTask
    implements Callable<TemplateUtil.SplitInfo> {
        private final InputSplit _split;
        private final TextInputFormat _inputFormat;
        private final JobConf _jobConf;
        private final String _beginString;
        private final String _endString;

        public CountSeqScatteredRowsTask(InputSplit split, TextInputFormat inputFormat, JobConf jobConf, String beginString, String endString) {
            this._split = split;
            this._inputFormat = inputFormat;
            this._jobConf = jobConf;
            this._beginString = beginString;
            this._endString = endString;
        }

        @Override
        public TemplateUtil.SplitInfo call() throws Exception {
            int i;
            ArrayList<Object> endIndexes;
            TemplateUtil.SplitInfo splitInfo = new TemplateUtil.SplitInfo();
            int nrows = 0;
            ArrayList<Pair<Long, Integer>> beginIndexes = TemplateUtil.getTokenIndexOnMultiLineRecords(this._split, this._inputFormat, this._jobConf, this._beginString).getKey();
            int tokenLength = 0;
            boolean diffBeginEndToken = false;
            if (!this._beginString.equals(this._endString)) {
                endIndexes = TemplateUtil.getTokenIndexOnMultiLineRecords(this._split, this._inputFormat, this._jobConf, this._endString).getKey();
                tokenLength = this._endString.length();
                diffBeginEndToken = true;
            } else {
                endIndexes = new ArrayList<Pair<Long, Integer>>();
                for (i = 1; i < beginIndexes.size(); ++i) {
                    endIndexes.add(beginIndexes.get(i));
                }
            }
            beginIndexes.remove(beginIndexes.size() - 1);
            i = 0;
            int j = 0;
            if (beginIndexes.get(0).getKey() > (Long)((Pair)endIndexes.get(0)).getKey()) {
                ++j;
            }
            while (i < beginIndexes.size() && j < endIndexes.size()) {
                Pair<Long, Integer> p1 = beginIndexes.get(i);
                Pair p2 = (Pair)endIndexes.get(j);
                int n = 0;
                while (p1.getKey() < (Long)p2.getKey() || p1.getKey() == p2.getKey() && p1.getValue() < (Integer)p2.getValue()) {
                    ++n;
                    if (++i == beginIndexes.size()) break;
                    p1 = beginIndexes.get(i);
                }
                splitInfo.addIndexAndPosition(beginIndexes.get(i - n).getKey(), (Long)((Pair)endIndexes.get(j += n - 1)).getKey(), beginIndexes.get(i - n).getValue(), (Integer)((Pair)endIndexes.get(j)).getValue() + tokenLength);
                ++j;
                ++nrows;
            }
            if (!diffBeginEndToken && i == beginIndexes.size() && j < endIndexes.size()) {
                ++nrows;
            }
            if (beginIndexes.get(0).getKey() == 0L && beginIndexes.get(0).getValue() == 0) {
                splitInfo.setRemainString("");
            } else {
                RecordReader reader = this._inputFormat.getRecordReader(this._split, this._jobConf, Reporter.NULL);
                LongWritable key = new LongWritable();
                Text value = new Text();
                StringBuilder sb = new StringBuilder();
                int ri = 0;
                while ((long)ri < beginIndexes.get(0).getKey()) {
                    reader.next((Object)key, (Object)value);
                    String raw = value.toString();
                    sb.append(raw);
                    ++ri;
                }
                if (beginIndexes.get(0).getValue() != 0) {
                    reader.next((Object)key, (Object)value);
                    sb.append(value.toString().substring(0, beginIndexes.get(0).getValue()));
                }
                splitInfo.setRemainString(sb.toString());
            }
            splitInfo.setNrows(nrows);
            return splitInfo;
        }
    }

    private class ReadTask
    implements Callable<Long> {
        private final InputSplit _split;
        private final TextInputFormat _informat;
        private final MatrixBlock _dest;
        private final int _splitCount;
        private long _nnz = 0L;

        public ReadTask(InputSplit split, TextInputFormat informat, MatrixBlock dest, int splitCount) {
            this._split = split;
            this._informat = informat;
            this._dest = dest;
            this._splitCount = splitCount;
        }

        @Override
        public Long call() throws IOException {
            RecordReader reader = this._informat.getRecordReader(this._split, MatrixGenerateReaderParallel.this.job, Reporter.NULL);
            LongWritable key = new LongWritable();
            Text value = new Text();
            MutableInt rowPos = new MutableInt(MatrixGenerateReaderParallel.this._offsets.getOffsetPerSplit(this._splitCount));
            TemplateUtil.SplitInfo _splitInfo = MatrixGenerateReaderParallel.this._offsets.getSeqOffsetPerSplit(this._splitCount);
            this._nnz = MatrixGenerateReaderParallel.this.readMatrixFromHDFS((RecordReader<LongWritable, Text>)reader, key, value, this._dest, rowPos, _splitInfo);
            return this._nnz;
        }

        public long getNnz() {
            return this._nnz;
        }
    }
}

