/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.tokenize.lang;

import java.util.Set;
import java.util.regex.Pattern;
import opennlp.tools.tokenize.DefaultTokenContextGenerator;
import opennlp.tools.tokenize.TokenContextGenerator;

public class Factory {
    public static final Pattern DEFAULT_ALPHANUMERIC = Pattern.compile("^[A-Za-z0-9]+$");
    private static final Pattern PORTUGUESE = Pattern.compile("^[0-9a-z\u00e1\u00e3\u00e2\u00e0\u00e9\u00ea\u00ed\u00f3\u00f5\u00f4\u00fa\u00fc\u00e7A-Z\u00c1\u00c3\u00c2\u00c0\u00c9\u00ca\u00cd\u00d3\u00d5\u00d4\u00da\u00dc\u00c7]+$");
    private static final Pattern FRENCH = Pattern.compile("^[a-zA-Z0-9\u00e0\u00e2\u00e4\u00e8\u00e9\u00ea\u00eb\u00ee\u00ef\u00f4\u0153\u00f9\u00fb\u00fc\u00ff\u00e7\u00c0\u00c2\u00c4\u00c8\u00c9\u00ca\u00cb\u00ce\u00cf\u00d4\u0152\u00d9\u00db\u00dc\u0178\u00c7]+$");
    private static final Pattern DUTCH = Pattern.compile("^[A-Za-z0-9\u00e4\u00f6\u00fc\u00eb\u00e8\u00e9\u00ef\u0133\u00c4\u00d6\u00dc\u00cb\u00c9\u00c8\u00cf\u0132]+$");
    private static final Pattern GERMAN = Pattern.compile("^[A-Za-z0-9\u00e4\u00e9\u00f6\u00fc\u00c4\u00c9\u00d6\u00dc\u00df]+$");
    private static final Pattern POLISH = Pattern.compile("^[A-Za-z0-9\u017c\u017a\u0107\u0144\u00f3\u0142\u0119\u0105\u015b\u017b\u0179\u0106\u0104\u015a\u0118\u0141\u00d3\u0143]+$");
    private static final Pattern ITALIAN = Pattern.compile("^[0-9a-z\u00e0\u00e8\u00e9\u00ec\u00ee\u00ed\u00f2\u00f3\u00f9\u00fcA-Z\u00c0\u00c8\u00c9\u00cc\u00ce\u00cd\u00d2\u00d3\u00d9\u00dc]+$");
    private static final Pattern SPANISH = Pattern.compile("^[0-9a-z\u00e1\u00e9\u00ed\u00f3\u00fa\u00fc\u00fd\u00f1A-Z\u00c1\u00c9\u00cd\u00d3\u00da\u00dd\u00d1]+$");
    private static final Pattern CATALAN = Pattern.compile("^[0-9a-z\u00e0\u00e8\u00e9\u00ed\u00ef\u00f2\u00f3\u00fa\u00fc\u00e7A-Z\u00c0\u00c8\u00c9\u00cd\u00cf\u00d2\u00d3\u00da\u00dc\u00c7]+$");

    public Pattern getAlphanumeric(String languageCode) {
        if ("es".equals(languageCode) || "spa".equals(languageCode)) {
            return SPANISH;
        }
        if ("it".equals(languageCode) || "ita".equals(languageCode)) {
            return ITALIAN;
        }
        if ("pt".equals(languageCode) || "por".equals(languageCode)) {
            return PORTUGUESE;
        }
        if ("ca".equals(languageCode) || "cat".equals(languageCode)) {
            return CATALAN;
        }
        if ("pl".equals(languageCode) || "pol".equals(languageCode)) {
            return POLISH;
        }
        if ("de".equals(languageCode) || "deu".equals(languageCode) || "ger".equals(languageCode)) {
            return GERMAN;
        }
        if ("fr".equals(languageCode) || "fre".equals(languageCode) || "fra".equals(languageCode)) {
            return FRENCH;
        }
        if ("nl".equals(languageCode) || "nld".equals(languageCode) || "dut".equals(languageCode)) {
            return DUTCH;
        }
        return DEFAULT_ALPHANUMERIC;
    }

    public TokenContextGenerator createTokenContextGenerator(String languageCode, Set<String> abbreviations) {
        return new DefaultTokenContextGenerator(abbreviations);
    }
}

