/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.aggregate;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridCoverageProcessor;
import org.apache.sis.coverage.grid.IllegalGridGeometryException;
import org.apache.sis.image.Colorizer;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.aggregate.AggregatedResource;
import org.apache.sis.storage.aggregate.BandAggregateGridResource;
import org.apache.sis.storage.aggregate.GridSlice;
import org.apache.sis.storage.aggregate.Group;
import org.apache.sis.storage.aggregate.GroupAggregate;
import org.apache.sis.storage.aggregate.GroupByCRS;
import org.apache.sis.storage.aggregate.GroupBySample;
import org.apache.sis.storage.aggregate.GroupByTransform;
import org.apache.sis.storage.aggregate.MergeStrategy;
import org.apache.sis.storage.base.MemoryGridResource;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.collection.BackingStoreException;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.util.GenericName;

public final class CoverageAggregator
extends Group<GroupBySample> {
    private final StoreListeners listeners;
    private final Map<Set<Resource>, Queue<Aggregate>> aggregates;
    private volatile MergeStrategy strategy;
    private GridCoverageProcessor processor;

    public CoverageAggregator() {
        this(null);
    }

    public CoverageAggregator(StoreListeners listeners) {
        this.listeners = listeners;
        this.aggregates = new HashMap<Set<Resource>, Queue<Aggregate>>();
    }

    CoverageAggregator(StoreListeners listeners, GridCoverageProcessor processor) {
        this(listeners);
        this.processor = processor;
    }

    @Override
    final String createName(Locale locale) {
        return this.listeners != null ? this.listeners.getSourceName() : null;
    }

    public void add(GridCoverage coverage) {
        try {
            this.add(new MemoryGridResource(this.listeners, coverage, this.processor()));
        }
        catch (DataStoreException e) {
            Throwable cause = e.getCause();
            if (cause instanceof NoninvertibleTransformException) {
                throw new IllegalGridGeometryException(cause);
            }
            throw new BackingStoreException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(GridCoverageResource resource) throws DataStoreException {
        List slices;
        GroupBySample bySample = GroupBySample.getOrAdd(this.members, resource.getSampleDimensions());
        GridSlice slice = new GridSlice(resource);
        try {
            slices = slice.getList((List<GroupByCRS<GroupByTransform>>)bySample.members, (MergeStrategy)this.strategy).members;
        }
        catch (NoninvertibleTransformException e) {
            throw new DataStoreContentException(e);
        }
        List list = slices;
        synchronized (list) {
            slices.add(slice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addComponents(Aggregate resource) throws DataStoreException {
        boolean hasDuplicated = false;
        Set components = Collections.newSetFromMap(new IdentityHashMap());
        for (Resource resource2 : resource.components()) {
            if (components.add(resource2)) {
                if (resource2 instanceof GridCoverageResource) {
                    this.add((GridCoverageResource)resource2);
                    continue;
                }
                if (!(resource2 instanceof Aggregate)) continue;
                this.addComponents((Aggregate)resource2);
                continue;
            }
            hasDuplicated = true;
        }
        if (!hasDuplicated && !components.isEmpty()) {
            Map<Set<Resource>, Queue<Aggregate>> map = this.aggregates;
            synchronized (map) {
                this.aggregates.computeIfAbsent(components, k -> new ArrayDeque(1)).add(resource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Optional<Aggregate> existingAggregate(Resource[] components) {
        Set key = Collections.newSetFromMap(new IdentityHashMap());
        if (Collections.addAll(key, components)) {
            Queue<Aggregate> r;
            Map<Set<Resource>, Queue<Aggregate>> map = this.aggregates;
            synchronized (map) {
                r = this.aggregates.get(key);
            }
            if (r != null) {
                return Optional.ofNullable(r.poll());
            }
        }
        return Optional.empty();
    }

    public void addAll(Stream<? extends GridCoverageResource> resources) throws DataStoreException {
        try {
            resources.forEach(resource -> {
                try {
                    this.add((GridCoverageResource)resource);
                }
                catch (DataStoreException e) {
                    throw new BackingStoreException(e);
                }
            });
        }
        catch (BackingStoreException e) {
            throw e.unwrapOrRethrow(DataStoreException.class);
        }
    }

    public void addRangeAggregate(GridCoverageResource ... sources) throws DataStoreException {
        this.addRangeAggregate(sources, (int[][])null);
    }

    public void addRangeAggregate(GridCoverageResource[] sources, int[][] bandsPerSource) throws DataStoreException {
        if (sources.length != 0) {
            this.add(BandAggregateGridResource.create(this.listeners, sources, bandsPerSource, this.processor()));
        }
    }

    public Colorizer getColorizer() {
        return this.processor().getColorizer();
    }

    public void setColorizer(Colorizer colorizer) {
        this.processor().setColorizer(colorizer);
    }

    public MergeStrategy getMergeStrategy() {
        return this.strategy;
    }

    public void setMergeStrategy(MergeStrategy strategy) {
        this.strategy = strategy;
    }

    private synchronized GridCoverageProcessor processor() {
        if (this.processor == null) {
            this.processor = new GridCoverageProcessor();
        }
        return this.processor;
    }

    public synchronized Resource build(GenericName identifier) {
        GroupAggregate aggregate = this.prepareAggregate(this.listeners);
        aggregate.fillWithChildAggregates(this, GroupBySample::createComponents);
        Resource result = aggregate.simplify(this);
        if (result instanceof AggregatedResource) {
            ((AggregatedResource)((Object)result)).setIdentifier(identifier);
        }
        return result;
    }

    @Deprecated
    public Resource build() {
        return this.build(null);
    }
}

