/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.stubbing;

import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.http.LoggedResponse;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import wiremock.com.fasterxml.jackson.annotation.JsonCreator;
import wiremock.com.fasterxml.jackson.annotation.JsonIgnore;
import wiremock.com.fasterxml.jackson.annotation.JsonProperty;
import wiremock.com.google.common.base.Function;
import wiremock.com.google.common.base.Predicate;

public class ServeEvent {
    private final UUID id;
    private final LoggedRequest request;
    private final StubMapping stubMapping;
    private final ResponseDefinition responseDefinition;
    private final LoggedResponse response;
    public static final Function<ServeEvent, LoggedRequest> TO_LOGGED_REQUEST = new Function<ServeEvent, LoggedRequest>(){

        @Override
        public LoggedRequest apply(ServeEvent serveEvent) {
            return serveEvent.getRequest();
        }
    };
    public static final Predicate<ServeEvent> NOT_MATCHED = new Predicate<ServeEvent>(){

        @Override
        public boolean apply(ServeEvent serveEvent) {
            return serveEvent.isNoExactMatch();
        }
    };

    @JsonCreator
    public ServeEvent(@JsonProperty(value="id") UUID id, @JsonProperty(value="request") LoggedRequest request, @JsonProperty(value="mapping") StubMapping stubMapping, @JsonProperty(value="responseDefinition") ResponseDefinition responseDefinition, @JsonProperty(value="response") LoggedResponse response, @JsonProperty(value="wasMatched") boolean ignoredReadOnly) {
        this.id = id;
        this.request = request;
        this.responseDefinition = responseDefinition;
        this.stubMapping = stubMapping;
        this.response = response;
    }

    public ServeEvent(LoggedRequest request, StubMapping stubMapping, ResponseDefinition responseDefinition) {
        this(UUID.randomUUID(), request, stubMapping, responseDefinition, null, false);
    }

    public static ServeEvent forUnmatchedRequest(LoggedRequest request) {
        return new ServeEvent(request, null, ResponseDefinition.notConfigured());
    }

    public static ServeEvent of(LoggedRequest request, ResponseDefinition responseDefinition) {
        return new ServeEvent(request, null, responseDefinition);
    }

    public static ServeEvent of(LoggedRequest request, ResponseDefinition responseDefinition, StubMapping stubMapping) {
        return new ServeEvent(request, stubMapping, responseDefinition);
    }

    public ServeEvent complete(Response response) {
        return new ServeEvent(this.id, this.request, this.stubMapping, this.responseDefinition, LoggedResponse.from(response), false);
    }

    @JsonIgnore
    public boolean isNoExactMatch() {
        return !this.responseDefinition.wasConfigured();
    }

    public UUID getId() {
        return this.id;
    }

    public LoggedRequest getRequest() {
        return this.request;
    }

    public ResponseDefinition getResponseDefinition() {
        return this.responseDefinition;
    }

    public boolean getWasMatched() {
        return this.responseDefinition.wasConfigured();
    }

    public StubMapping getStubMapping() {
        return this.stubMapping;
    }

    public LoggedResponse getResponse() {
        return this.response;
    }

    @JsonIgnore
    public Map<String, Parameters> getPostServeActions() {
        return this.stubMapping != null && this.stubMapping.getPostServeActions() != null ? this.getStubMapping().getPostServeActions() : Collections.emptyMap();
    }
}

