/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mail.util;

import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.geronimo.mail.authentication.ClientAuthenticator;
import org.apache.geronimo.mail.authentication.CramMD5Authenticator;
import org.apache.geronimo.mail.authentication.DigestMD5Authenticator;
import org.apache.geronimo.mail.authentication.LoginAuthenticator;
import org.apache.geronimo.mail.authentication.PlainAuthenticator;
import org.apache.geronimo.mail.authentication.SASLAuthenticator;
import org.apache.geronimo.mail.util.ProtocolProperties;
import org.apache.geronimo.mail.util.TraceInputStream;
import org.apache.geronimo.mail.util.TraceOutputStream;

public class MailConnection {
    protected static final char CR = '\r';
    protected static final char LF = '\n';
    protected static final String MAIL_PORT = "port";
    protected static final String MAIL_LOCALHOST = "localhost";
    protected static final String MAIL_STARTTLS_ENABLE = "starttls.enable";
    protected static final String MAIL_STARTTLS_REQUIRED = "starttls.required";
    protected static final String MAIL_SSL_ENABLE = "ssl.enable";
    protected static final String MAIL_TIMEOUT = "timeout";
    protected static final String MAIL_SASL_ENABLE = "sasl.enable";
    protected static final String MAIL_SASL_REALM = "sasl.realm";
    protected static final String MAIL_AUTHORIZATIONID = "sasl.authorizationid";
    protected static final String MAIL_SASL_MECHANISMS = "sasl.mechanisms";
    protected static final String MAIL_PLAIN_DISABLE = "auth.plain.disable";
    protected static final String MAIL_LOGIN_DISABLE = "auth.login.disable";
    protected static final String MAIL_FACTORY = "socketFactory";
    protected static final String MAIL_FACTORY_CLASS = "socketFactory.class";
    protected static final String MAIL_FACTORY_FALLBACK = "socketFactory.fallback";
    protected static final String MAIL_FACTORY_PORT = "socketFactory.port";
    protected static final String MAIL_SSL_FACTORY = "ssl.socketFactory";
    protected static final String MAIL_SSL_FACTORY_CLASS = "ssl.socketFactory.class";
    protected static final String MAIL_SSL_FACTORY_PORT = "ssl.socketFactory.port";
    protected static final String MAIL_SSL_PROTOCOLS = "ssl.protocols";
    protected static final String MAIL_SSL_CIPHERSUITES = "ssl.ciphersuites";
    protected static final String MAIL_SSL_TRUST = "ssl.trust";
    protected static final String MAIL_LOCALADDRESS = "localaddress";
    protected static final String MAIL_LOCALPORT = "localport";
    protected static final String MAIL_ENCODE_TRACE = "encodetrace";
    protected static final int MIN_MILLIS = 60000;
    protected static final int TIMEOUT = 300000;
    protected static final String DEFAULT_MAIL_HOST = "localhost";
    protected static final String CAPABILITY_STARTTLS = "STARTTLS";
    protected static final String AUTHENTICATION_PLAIN = "PLAIN";
    protected static final String AUTHENTICATION_LOGIN = "LOGIN";
    protected static final String AUTHENTICATION_CRAMMD5 = "CRAM-MD5";
    protected static final String AUTHENTICATION_DIGESTMD5 = "DIGEST-MD5";
    protected static final String AUTHENTICATION_XOAUTH2 = "XOAUTH2";
    protected Session session;
    protected String protocol;
    protected boolean sslConnection;
    protected int defaultPort;
    protected ProtocolProperties props;
    protected String serverHost;
    protected int serverPort;
    protected Socket socket;
    protected InetAddress localAddress;
    protected int localPort;
    protected String localHost;
    protected int timeout;
    protected String username;
    protected String password;
    protected String realm;
    protected String authid;
    protected InputStream inputStream;
    protected OutputStream outputStream;
    protected PrintStream debugStream;
    protected boolean debug;
    protected List authentications;
    protected Map capabilities;
    protected List mechanisms;

    protected MailConnection(ProtocolProperties props) {
        this.props = props;
        this.protocol = props.getProtocol();
        this.session = props.getSession();
        this.sslConnection = props.getSSLConnection();
        this.defaultPort = props.getDefaultPort();
        this.debug = this.session.getDebug();
        this.debugStream = this.session.getDebugOut();
        String mailSSLEnable = props.getProperty(MAIL_SSL_ENABLE);
        if (mailSSLEnable != null) {
            this.sslConnection = Boolean.valueOf(mailSSLEnable);
        }
    }

    public boolean protocolConnect(String host, int port, String username, String password) throws MessagingException {
        if (port == -1 && (port = this.props.getIntProperty(MAIL_PORT, this.props.getDefaultPort())) == -1) {
            port = this.props.getDefaultPort();
        }
        if (host == null) {
            host = "localhost";
        }
        this.serverHost = host;
        this.serverPort = port;
        this.username = username;
        this.password = password;
        this.realm = this.props.getProperty(MAIL_SASL_REALM);
        this.authid = this.props.getProperty(MAIL_AUTHORIZATIONID, username);
        return true;
    }

    public void connect(Socket s) {
        this.socket = s;
    }

    protected void getConnection() throws IOException, MessagingException {
        if (this.socket == null) {
            this.getConnectionProperties();
            if (this.sslConnection) {
                this.getConnectedSSLSocket();
            } else {
                this.getConnectedSocket();
            }
        } else {
            this.localPort = this.socket.getPort();
            this.localAddress = this.socket.getInetAddress();
        }
        this.getConnectionStreams();
    }

    protected void getConnectionProperties() {
        this.timeout = this.props.getIntProperty(MAIL_TIMEOUT, -1);
        this.localAddress = null;
        String localAddrProp = this.props.getProperty(MAIL_LOCALADDRESS);
        if (localAddrProp != null) {
            try {
                this.localAddress = InetAddress.getByName(localAddrProp);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        this.localPort = this.props.getIntProperty(MAIL_LOCALPORT, 0);
    }

    protected void getConnectedSocket() throws IOException {
        this.debugOut("Attempting plain socket connection to server " + this.serverHost + ":" + this.serverPort);
        this.socket = null;
        this.createSocket(false);
        if (this.timeout >= 0) {
            this.socket.setSoTimeout(this.timeout);
        }
    }

    private boolean createSocketFromFactory(boolean ssl, boolean layer) throws IOException {
        String socketFactoryClass = this.props.getProperty(ssl ? MAIL_SSL_FACTORY_CLASS : MAIL_FACTORY_CLASS);
        if (socketFactoryClass == null) {
            return false;
        }
        boolean fallback = this.props.getBooleanProperty(MAIL_FACTORY_FALLBACK, false);
        int socketFactoryPort = this.props.getIntProperty(ssl ? MAIL_SSL_FACTORY_PORT : MAIL_FACTORY_PORT, -1);
        Integer portArg = new Integer(socketFactoryPort == -1 ? this.serverPort : socketFactoryPort);
        this.debugOut("Creating " + (ssl ? "" : "non-") + "SSL socket using factory " + socketFactoryClass + " listening on port " + portArg);
        while (true) {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> factoryClass = loader.loadClass(socketFactoryClass);
                Object defFactory = factoryClass.newInstance();
                if (this.localAddress != null && !layer) {
                    Class[] createSocketSig = new Class[]{String.class, Integer.TYPE, InetAddress.class, Integer.TYPE};
                    Method createSocket = factoryClass.getMethod("createSocket", createSocketSig);
                    Object[] createSocketArgs = new Object[]{this.serverHost, portArg, this.localAddress, new Integer(this.localPort)};
                    this.socket = (Socket)createSocket.invoke(defFactory, createSocketArgs);
                    break;
                }
                if (layer) {
                    Class[] createSocketSig = new Class[]{Socket.class, String.class, Integer.TYPE, Boolean.TYPE};
                    Method createSocket = factoryClass.getMethod("createSocket", createSocketSig);
                    Object[] createSocketArgs = new Object[]{this.socket, this.serverHost, new Integer(this.serverPort), Boolean.TRUE};
                    this.socket = (Socket)createSocket.invoke(defFactory, createSocketArgs);
                    break;
                }
                Class[] createSocketSig = new Class[]{String.class, Integer.TYPE};
                Method createSocket = factoryClass.getMethod("createSocket", createSocketSig);
                Object[] createSocketArgs = new Object[]{this.serverHost, portArg};
                this.socket = (Socket)createSocket.invoke(defFactory, createSocketArgs);
            }
            catch (Throwable e) {
                if (fallback) {
                    this.debugOut("First attempt at creating " + (ssl ? "" : "non-") + "SSL socket failed, falling back to default factory");
                    socketFactoryClass = ssl ? "javax.net.ssl.SSLSocketFactory" : "javax.net.SocketFactory";
                    fallback = false;
                    continue;
                }
                if (e instanceof InvocationTargetException) {
                    e = ((InvocationTargetException)e).getTargetException();
                }
                this.debugOut("Failure creating " + (ssl ? "" : "non-") + "SSL socket", e);
                IOException ioe = new IOException("Error connecting to " + this.serverHost + ", " + this.serverPort);
                ioe.initCause(e);
                throw ioe;
            }
            break;
        }
        return true;
    }

    private void createSocketFromFactory(SocketFactory sf, boolean layer) throws IOException {
        if (sf instanceof SSLSocketFactory && layer) {
            this.socket = ((SSLSocketFactory)sf).createSocket(this.socket, this.serverHost, this.serverPort, true);
            return;
        }
        this.socket = this.localAddress != null ? sf.createSocket(this.serverHost, this.serverPort, this.localAddress, this.localPort) : sf.createSocket(this.serverHost, this.serverPort);
    }

    private boolean createSocketFromConfiguredFactoryInstance(boolean ssl, boolean layer) throws IOException {
        if (ssl) {
            Object sfProp = this.props.getPropertyAsObject(MAIL_SSL_FACTORY);
            if (sfProp != null && sfProp instanceof SSLSocketFactory) {
                this.createSocketFromFactory((SSLSocketFactory)sfProp, layer);
                this.debugOut("Creating " + (ssl ? "" : "non-") + "SSL " + (layer ? "layered" : "non-layered") + " socket using a instance of factory " + sfProp.getClass() + " listening");
                return true;
            }
        } else {
            Object sfProp = this.props.getPropertyAsObject(MAIL_FACTORY);
            if (sfProp != null && sfProp instanceof SocketFactory) {
                this.createSocketFromFactory((SocketFactory)sfProp, layer);
                this.debugOut("Creating " + (ssl ? "" : "non-") + "SSL " + (layer ? "layered" : "non-layered") + " socket using a instance of factory " + sfProp.getClass() + " listening");
                return true;
            }
        }
        return false;
    }

    private void createSSLSocketFromSSLContext(boolean layer) throws IOException {
        this.debugOut("Creating " + (layer ? "layered " : "non-layered ") + "SSL socket using SSL Context");
        try {
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            String sslTrust = this.props.getProperty(MAIL_SSL_TRUST);
            SSLTrustManager trustManager = null;
            if (sslTrust != null) {
                if (sslTrust.equals("*")) {
                    trustManager = new SSLTrustManager(null, true);
                } else {
                    String[] trustedHosts = sslTrust.split("\\s+");
                    trustManager = new SSLTrustManager(trustedHosts, false);
                    if (this.serverHost == null || this.serverHost.isEmpty() || !Arrays.asList(trustedHosts).contains(this.serverHost)) {
                        throw new IOException("Server is not trusted: " + this.serverHost);
                    }
                }
            } else {
                trustManager = new SSLTrustManager(null, false);
            }
            sslcontext.init(null, new TrustManager[]{trustManager}, null);
            this.createSocketFromFactory(sslcontext.getSocketFactory(), layer);
        }
        catch (KeyManagementException e) {
            throw new IOException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
    }

    private void createSocket(boolean ssl) throws IOException {
        if (this.createSocketFromConfiguredFactoryInstance(ssl, false)) {
            return;
        }
        if (this.createSocketFromFactory(ssl, false)) {
            return;
        }
        if (!ssl) {
            this.createSocketFromFactory(SocketFactory.getDefault(), false);
            return;
        }
        this.createSSLSocketFromSSLContext(false);
    }

    protected void getConnectedSSLSocket() throws IOException {
        String[] suites;
        String[] protocols;
        this.debugOut("Attempting SSL socket connection to server " + this.serverHost + ":" + this.serverPort);
        this.socket = null;
        this.createSocket(true);
        if (this.timeout >= 0) {
            this.socket.setSoTimeout(this.timeout);
        }
        if ((protocols = this.getFromWhitespaceSeparatedProperty(MAIL_SSL_PROTOCOLS)) != null) {
            ((SSLSocket)this.socket).setEnabledProtocols(protocols);
        }
        if ((suites = this.getFromWhitespaceSeparatedProperty(MAIL_SSL_CIPHERSUITES)) != null) {
            ((SSLSocket)this.socket).setEnabledCipherSuites(suites);
        }
    }

    protected String[] getFromWhitespaceSeparatedProperty(String propertyName) {
        String property = this.props.getProperty(propertyName);
        if (property != null) {
            ArrayList<String> list = new ArrayList<String>();
            StringTokenizer t = new StringTokenizer(property);
            while (t.hasMoreTokens()) {
                list.add(t.nextToken());
            }
            return list.toArray(new String[0]);
        }
        return null;
    }

    protected void getConnectedTLSSocket() throws MessagingException {
        try {
            this.serverHost = this.socket.getInetAddress().getHostName();
            this.serverPort = this.socket.getPort();
            if (this.createSocketFromConfiguredFactoryInstance(true, true)) {
                this.debugOut("TLS socket factory configured as instance");
            } else if (this.createSocketFromFactory(true, true)) {
                this.debugOut("TLS socket factory configured as class");
            } else {
                this.debugOut("TLS socket factory from SSLContext");
                this.createSSLSocketFromSSLContext(true);
            }
            if (this.socket instanceof SSLSocket) {
                Object[] suites = this.getFromWhitespaceSeparatedProperty(MAIL_SSL_CIPHERSUITES);
                if (suites == null) {
                    suites = ((SSLSocket)this.socket).getSupportedCipherSuites();
                    this.debugOut("No custom ciphers are specified, using all supported ciphers of the given SSLSocket: " + Arrays.toString(suites));
                }
                ((SSLSocket)this.socket).setEnabledCipherSuites((String[])suites);
                String[] protocols = this.getFromWhitespaceSeparatedProperty(MAIL_SSL_PROTOCOLS);
                if (protocols != null) {
                    ((SSLSocket)this.socket).setEnabledProtocols(protocols);
                } else {
                    this.debugOut("No custom protocols specified, using the enabled protocols of the given SSLSocket: " + Arrays.toString(((SSLSocket)this.socket).getEnabledProtocols()));
                }
            } else {
                throw new IOException("Socket is not an instance of SSLSocket, maybe wrong configured ssl factory?");
            }
            ((SSLSocket)this.socket).setUseClientMode(true);
            this.debugOut("Initiating STARTTLS handshake");
            ((SSLSocket)this.socket).startHandshake();
            this.getConnectionStreams();
            this.debugOut("TLS connection established");
        }
        catch (Exception e) {
            this.debugOut("Failure attempting to convert connection to TLS", e);
            throw new MessagingException("Unable to convert connection to TLS", e);
        }
    }

    protected void getConnectionStreams() throws MessagingException, IOException {
        this.inputStream = new TraceInputStream(this.socket.getInputStream(), this.debugStream, this.debug, this.props.getBooleanProperty(MAIL_ENCODE_TRACE, false));
        this.outputStream = new BufferedOutputStream(new TraceOutputStream(this.socket.getOutputStream(), this.debugStream, this.debug, this.props.getBooleanProperty(MAIL_ENCODE_TRACE, false)));
    }

    public void closeServerConnection() {
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.socket = null;
        this.inputStream = null;
        this.outputStream = null;
    }

    protected void checkConnected() throws MessagingException {
        if (this.socket == null || !this.socket.isConnected()) {
            throw new MessagingException("no connection");
        }
    }

    public String getSASLRealm() {
        if (this.realm == null) {
            this.realm = this.props.getProperty(MAIL_SASL_REALM);
        }
        return this.realm;
    }

    public void setSASLRealm(String name) {
        this.realm = name;
    }

    protected List getSaslMechanisms() {
        if (this.mechanisms == null) {
            this.mechanisms = new ArrayList();
            String mechList = this.props.getProperty(MAIL_SASL_MECHANISMS);
            if (mechList != null) {
                StringTokenizer tokenizer = new StringTokenizer(mechList, " ,");
                while (tokenizer.hasMoreTokens()) {
                    String mech = tokenizer.nextToken().toUpperCase();
                    this.mechanisms.add(mech);
                }
            }
        }
        return this.mechanisms;
    }

    protected List getServerMechanisms() {
        return this.authentications;
    }

    protected List selectSaslMechanisms() {
        List configured = this.getSaslMechanisms();
        List supported = this.getServerMechanisms();
        if (configured.isEmpty()) {
            return supported;
        }
        ArrayList<String> merged = new ArrayList<String>();
        for (int i = 0; i < configured.size(); ++i) {
            String mech = (String)configured.get(i);
            if (!supported.contains(mech)) continue;
            merged.add(mech);
        }
        return merged;
    }

    protected ClientAuthenticator getLoginAuthenticator() throws MessagingException {
        List mechs = this.selectSaslMechanisms();
        try {
            String[] mechArray = mechs.toArray(new String[0]);
            return new SASLAuthenticator(mechArray, this.session.getProperties(), this.protocol, this.serverHost, this.getSASLRealm(), this.authid, this.username, this.password);
        }
        catch (Throwable throwable) {
            if (mechs.contains(AUTHENTICATION_DIGESTMD5)) {
                return new DigestMD5Authenticator(this.serverHost, this.username, this.password, this.getSASLRealm());
            }
            if (mechs.contains(AUTHENTICATION_CRAMMD5)) {
                return new CramMD5Authenticator(this.username, this.password);
            }
            if (mechs.contains(AUTHENTICATION_LOGIN)) {
                return new LoginAuthenticator(this.username, this.password);
            }
            if (mechs.contains(AUTHENTICATION_PLAIN)) {
                return new PlainAuthenticator(this.authid, this.username, this.password);
            }
            return null;
        }
    }

    protected void debugOut(String message) {
        if (this.debug) {
            this.debugStream.println(this.protocol + " DEBUG: " + message);
        }
    }

    protected void debugOut(String message, Throwable e) {
        if (this.debug) {
            this.debugOut("Received exception -> " + message);
            this.debugOut("Exception message -> " + e.getMessage());
            e.printStackTrace(this.debugStream);
        }
    }

    public boolean hasCapability(String capability) {
        return this.capabilities.containsKey(capability);
    }

    public Map getCapabilities() {
        return this.capabilities;
    }

    public boolean supportsMechanism(String mech) {
        return this.authentications.contains(mech);
    }

    public String getHost() {
        return this.serverHost;
    }

    public String getLocalHost() throws MessagingException {
        if (this.localHost == null) {
            if (this.localHost == null) {
                this.localHost = this.props.getProperty("localhost");
            }
            if (this.localHost == null) {
                this.localHost = this.props.getSessionProperty("localhost");
            }
            if (this.localHost == null) {
                try {
                    this.localHost = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
            if (this.localHost == null) {
                throw new MessagingException("Can't get local hostname.  Please correctly configure JDK/DNS or set mail.smtp.localhost");
            }
        }
        return this.localHost;
    }

    public void setLocalHost(String localHost) {
        this.localHost = localHost;
    }

    private class SSLTrustManager
    implements X509TrustManager {
        private final X509TrustManager defaultTrustManager;
        private final boolean trustAll;
        private final String[] trustedHosts;

        SSLTrustManager(String[] trustedHosts, boolean trustAll) throws IOException {
            this.trustAll = trustAll;
            this.trustedHosts = trustedHosts;
            try {
                TrustManagerFactory defaultTrustManagerFactory = TrustManagerFactory.getInstance("X509");
                defaultTrustManagerFactory.init((KeyStore)null);
                this.defaultTrustManager = (X509TrustManager)defaultTrustManagerFactory.getTrustManagers()[0];
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException(e);
            }
            catch (KeyStoreException e) {
                throw new IOException(e);
            }
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.defaultTrustManager.checkClientTrusted(chain, authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            if (!this.trustAll || this.trustedHosts != null) {
                this.defaultTrustManager.checkServerTrusted(chain, authType);
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.defaultTrustManager.getAcceptedIssuers();
        }
    }
}

